/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.internal;

import java.security.Key;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dotnet.transport.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncrypUtil {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private static final String AES_PREFIX = "{AES}";

    static Hashtable<String, String> decrypt(Transport transport, Hashtable<String, String> hashtable) throws Exception {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>(hashtable);
        Cipher cipher = EncrypUtil.createCipher(transport);
        hashtable2 = EncrypUtil.decode(cipher, "java.naming.security.principal", hashtable2);
        hashtable2 = EncrypUtil.decode(cipher, "java.naming.security.credentials", hashtable2);
        return hashtable2;
    }

    static String decryptString(Transport transport, String string) throws Exception {
        Cipher cipher = EncrypUtil.createCipher(transport);
        return EncrypUtil.decryptString(cipher, string);
    }

    private static Hashtable<String, String> decode(Cipher cipher, String string, Hashtable<String, String> hashtable) throws Exception {
        int n = 33;
        int n2 = 13;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>(hashtable);
        if (hashtable2.containsKey(string)) {
            String string2 = hashtable2.get(string);
            if (string2 != null && string2.startsWith(AES_PREFIX)) {
                String string3;
                byte[] byArray = new BASE64Decoder().decodeBuffer(string2 = string2.substring(AES_PREFIX.length()));
                byte[] byArray2 = cipher.doFinal(byArray);
                int n3 = byArray2.length - n - n2;
                if (n3 < 0) {
                    throw new Exception("The encrypted data for " + string + " is not right");
                }
                if (n3 > 0) {
                    byte[] byArray3 = new byte[n3];
                    System.arraycopy(byArray2, n, byArray3, 0, n3);
                    string3 = new String(byArray3, "US-ASCII");
                } else {
                    string3 = "";
                }
                if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                    JMSDebug.JMSDotNetProxy.debug("Encrypted = true  for " + string + "; partial encrypted text : " + string2.substring(0, 5));
                }
                hashtable2.put(string, string3);
            } else if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                JMSDebug.JMSDotNetProxy.debug("Encrypted = false  for " + string + "; partial text : " + "*****");
            }
        }
        return hashtable2;
    }

    private static Cipher createCipher(Transport transport) throws Exception {
        long l = transport.getScratchId();
        byte[] byArray = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>>= 8;
        }
        byArray[8] = -19;
        byArray[9] = 29;
        byArray[10] = -17;
        byArray[11] = 74;
        byArray[12] = -101;
        byArray[13] = 37;
        byArray[14] = -119;
        byArray[15] = -95;
        byte[] byArray2 = new byte[]{123, byArray[3], 34, byArray[0], -8, byArray[2], 34, byArray[7], 121, byArray[6], -67, byArray[1], 100, byArray[4], 99, -40};
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        return cipher;
    }

    private static String decryptString(Cipher cipher, String string) throws Exception {
        String string2;
        int n = 33;
        int n2 = 13;
        if (string != null && string.startsWith(AES_PREFIX)) {
            String string3 = string;
            byte[] byArray = new BASE64Decoder().decodeBuffer(string = string.substring(AES_PREFIX.length()));
            byte[] byArray2 = cipher.doFinal(byArray);
            int n3 = byArray2.length - n - n2;
            if (n3 <= 0) {
                throw new Exception("The encrypted data for " + string + " is not right");
            }
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, n, byArray3, 0, n3);
            string2 = new String(byArray3, "US-ASCII");
            if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                JMSDebug.JMSDotNetProxy.debug("Encrypted = true; partial encrypted text : " + string3.substring(0, 5));
            }
        } else {
            if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                JMSDebug.JMSDotNetProxy.debug("Encrypted = false; partial text : *****");
            }
            string2 = string;
        }
        return string2;
    }
}

