/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.internal;

import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.dotnet.proxy.internal.BaseProxy;
import weblogic.jms.dotnet.proxy.internal.ConnectionFactoryProxy;
import weblogic.jms.dotnet.proxy.internal.ConnectionProxy;
import weblogic.jms.dotnet.proxy.internal.ProxyManagerImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyContextCloseRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyContextLookupConnectionFactoryRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyContextLookupConnectionFactoryResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxyContextLookupDestinationRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyContextLookupDestinationResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxyVoidResponse;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.ReceivedTwoWay;
import weblogic.jms.dotnet.transport.ServiceTwoWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.extensions.WLDestination;
import weblogic.jndi.internal.WLInternalContext;
import weblogic.protocol.ChannelHelperBase;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.AbstractSubject;

public class InitialContextProxy
extends BaseProxy
implements ServiceTwoWay {
    private HashMap<Long, ConnectionProxy> connections = new HashMap();
    private HashSet<Long> cfServiceIds = new HashSet();
    private Context initialContext;
    private Transport transport;
    private AbstractSubject subject;
    private boolean closedAll;

    public InitialContextProxy(Transport transport, long l, Context context) {
        super(l, null);
        this.initialContext = context;
        this.transport = transport;
        this.subject = JMSSecurityHelper.getCurrentSubject();
        if (SubjectUtils.doesUserHaveAnyAdminRoles((AuthenticatedSubject)((AuthenticatedSubject)this.subject)) && ChannelHelperBase.isLocalAdminChannelEnabled()) {
            throw new SecurityException("Server has admin channel configured, therefore admin traffic from .NET client is not allowed to go through");
        }
        if (JMSSecurityHelper.isServerIdentity((AuthenticatedSubject)this.subject)) {
            this.subject = JMSSecurityHelper.getAnonymousSubject();
        }
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Creating initial context: subject = " + this.subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MarshalWritable lookupFactory(final String string) {
        long l = 0L;
        ConnectionFactoryProxy connectionFactoryProxy = null;
        InitialContextProxy initialContextProxy = this;
        synchronized (initialContextProxy) {
            try {
                ConnectionFactory connectionFactory = (ConnectionFactory)JMSSecurityHelper.doAsJNDIOperation(this.subject, new PrivilegedExceptionAction(){

                    public Object run() throws NamingException {
                        return InitialContextProxy.this.initialContext.lookup(string);
                    }
                });
                if (!(connectionFactory instanceof JMSConnectionFactory)) {
                    return new TransportError(new JMSException("The connection factory is not a WebLogic JMS connection factory.  The WebLogic JMS .NET client supports WebLogic JMS destinations and connection factories."));
                }
                l = this.transport.allocateServiceID();
                connectionFactoryProxy = new ConnectionFactoryProxy(l, string, this, connectionFactory);
                this.transport.registerService(l, connectionFactoryProxy);
                this.addServiceId(l);
            }
            catch (ClassCastException classCastException) {
                return new TransportError(classCastException);
            }
            catch (JMSException jMSException) {
                return new TransportError(jMSException);
            }
            catch (NamingException namingException) {
                return new TransportError(namingException);
            }
        }
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Looked up connection factory: id = " + l + " factory = " + connectionFactoryProxy);
        }
        return new ProxyContextLookupConnectionFactoryResponse(l);
    }

    private final MarshalWritable lookupDestination(final String string) {
        Destination destination = null;
        try {
            destination = (Destination)JMSSecurityHelper.doAsJNDIOperation(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return InitialContextProxy.this.initialContext.lookup(string);
                }
            });
            if (!(destination instanceof WLDestination)) {
                return new TransportError(new JMSException("The destination is not a WebLogic JMS destination.  The WebLogic JMS .NET client supports WebLogic JMS destinations and connection factories."));
            }
            if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                JMSDebug.JMSDotNetProxy.debug("Looked up JMS destination: " + destination);
            }
            return new ProxyContextLookupDestinationResponse(destination);
        }
        catch (ClassCastException classCastException) {
            return new TransportError(classCastException);
        }
        catch (JMSException jMSException) {
            return new TransportError(jMSException);
        }
        catch (NamingException namingException) {
            return new TransportError(namingException);
        }
    }

    private void close() {
        this.closeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal() {
        InitialContextProxy initialContextProxy = this;
        synchronized (initialContextProxy) {
            if ((this.state & 1) != 0) {
                return;
            }
            this.state = 1;
        }
        try {
            JMSSecurityHelper.doAs(this.subject, new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    if (InitialContextProxy.this.initialContext instanceof WLInternalContext) {
                        ((WLInternalContext)InitialContextProxy.this.initialContext).disableThreadWarningOnClose();
                    }
                    InitialContextProxy.this.initialContext.close();
                    return null;
                }
            });
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        ProxyManagerImpl.getProxyManager().removeContext(this.getServiceId());
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Closed initial context:  id = " + this.getServiceId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAll() {
        InitialContextProxy initialContextProxy = this;
        synchronized (initialContextProxy) {
            this.closedAll = true;
        }
        this.cleanup(false);
    }

    synchronized void addConnection(long l, ConnectionProxy connectionProxy) throws JMSException {
        this.checkShutdownOrClosed("The context has been closed");
        this.connections.put(l, connectionProxy);
    }

    synchronized void remove(long l) {
        this.connections.remove(l);
    }

    InitialContextProxy getContext() {
        return this;
    }

    private synchronized boolean isClosedAll() {
        return this.closedAll;
    }

    public final void invoke(ReceivedTwoWay receivedTwoWay) {
        if (this.isShutdown()) {
            receivedTwoWay.send(new TransportError(new JMSException("The JMS service is shutting down")));
            return;
        }
        if (this.isClosedAll()) {
            receivedTwoWay.send(new TransportError(new JMSException("The context has been closed")));
            return;
        }
        MarshalReadable marshalReadable = receivedTwoWay.getRequest();
        MarshalWritable marshalWritable = null;
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Invoking: code = " + marshalReadable.getMarshalTypeCode() + " request = " + marshalReadable);
        }
        switch (marshalReadable.getMarshalTypeCode()) {
            case 3: {
                marshalWritable = this.lookupFactory(((ProxyContextLookupConnectionFactoryRequest)marshalReadable).getJNDIName());
                break;
            }
            case 5: {
                marshalWritable = this.lookupDestination(((ProxyContextLookupDestinationRequest)marshalReadable).getJNDIName());
                break;
            }
            case 7: {
                if (((ProxyContextCloseRequest)marshalReadable).isCloseAll()) {
                    this.closeAll();
                } else {
                    this.close();
                }
                marshalWritable = ProxyVoidResponse.THE_ONE;
                break;
            }
            default: {
                marshalWritable = new TransportError("Invalid MarshalReadableType : " + marshalReadable.getMarshalTypeCode(), false);
            }
        }
        receivedTwoWay.send(marshalWritable);
    }

    private synchronized void addServiceId(long l) throws JMSException {
        this.checkShutdownOrClosed("The session has been closed");
        this.cfServiceIds.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(boolean bl) {
        if (bl) {
            return;
        }
        this.closeInternal();
        Iterator iterator = null;
        BaseProxy baseProxy = this;
        synchronized (baseProxy) {
            iterator = ((HashMap)this.connections.clone()).values().iterator();
            this.connections.clear();
        }
        while (iterator.hasNext()) {
            baseProxy = (ConnectionProxy)iterator.next();
            try {
                ((ConnectionProxy)baseProxy).close();
            }
            catch (JMSException jMSException) {}
        }
        this.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister() {
        this.transport.unregisterService(this.serviceId);
        InitialContextProxy initialContextProxy = this;
        synchronized (initialContextProxy) {
            for (long l : this.cfServiceIds) {
                this.getTransport().unregisterService(l);
            }
            this.cfServiceIds.clear();
        }
    }

    public void onPeerGone(TransportError transportError) {
        this.cleanup(false);
    }

    public void onShutdown() {
    }

    public void onUnregister() {
    }

    public Transport getTransport() {
        return this.transport;
    }

    public AbstractSubject getSubject() {
        return this.subject;
    }
}

