/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.internal;

import java.security.PrivilegedExceptionAction;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dotnet.proxy.internal.BaseProxy;
import weblogic.jms.dotnet.proxy.internal.InitialContextProxy;
import weblogic.jms.dotnet.proxy.internal.SessionProxy;
import weblogic.jms.dotnet.proxy.protocol.ProxyBytesMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyDestinationImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyHdrMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyMapMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyObjectMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyProducerSendRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyProducerSendResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxyStreamMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyTextMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyVoidResponse;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.ReceivedTwoWay;
import weblogic.jms.dotnet.transport.ServiceTwoWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.extensions.AsyncSendResponseInfo;
import weblogic.jms.extensions.WLAsyncSession;
import weblogic.jms.extensions.WLMessage;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.security.subject.AbstractSubject;

public final class ProducerProxy
extends BaseProxy
implements ServiceTwoWay {
    private MessageProducer producer;
    private final ProxyDestinationImpl destination;
    private final WLAsyncSession wlAsyncSession;
    private static final boolean USE_ASYNC;

    ProducerProxy(long l, SessionProxy sessionProxy, MessageProducer messageProducer, ProxyDestinationImpl proxyDestinationImpl) throws JMSException {
        super(l, sessionProxy);
        this.producer = messageProducer;
        this.destination = proxyDestinationImpl;
        this.wlAsyncSession = USE_ASYNC && sessionProxy.getSession() instanceof WLAsyncSession ? (WLAsyncSession)sessionProxy.getSession() : null;
        if (messageProducer instanceof WLMessageProducer && ((WLMessageProducer)messageProducer).getRedeliveryLimit() == -1) {
            ((WLMessageProducer)messageProducer).setRedeliveryLimit(0x3FFFFFFF);
        }
    }

    private void send(final Destination destination, final Message message, final int n, final int n2, final long l) throws JMSException {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("SendSync(): destination = " + destination + " message = " + message + " deliveryMode = " + n + " priority = " + n2 + " timeToLive = " + l);
        }
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                ProducerProxy.this.producer.send(destination, message, n, n2, l);
                return null;
            }
        });
    }

    private void send(final Message message, final int n, final int n2, final long l) throws JMSException {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("SendSync(): message = " + message + " deliveryMode = " + n + " priority = " + n2 + " timeToLive = " + l);
        }
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                ProducerProxy.this.producer.send(message, n, n2, l);
                return null;
            }
        });
    }

    private void sendAsync(final ProxyProducerSendRequest proxyProducerSendRequest, final Destination destination, final Message message, final int n, final int n2, final long l) throws JMSException {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("SendAsync(): destination = " + this.destination + " message = " + message + " deliveryMode = " + n + " priority = " + n2 + " timeToLive = " + l);
        }
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                ProducerProxy.this.wlAsyncSession.sendAsync((WLMessageProducer)ProducerProxy.this.producer, destination, message, n, n2, l, proxyProducerSendRequest);
                return null;
            }
        });
    }

    private void sendAsync(final ProxyProducerSendRequest proxyProducerSendRequest, final Message message, final int n, final int n2, final long l) throws JMSException {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("SendAsync(): message = " + message + " deliveryMode = " + n + " priority = " + n2 + " timeToLive = " + l);
        }
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                ProducerProxy.this.wlAsyncSession.sendAsync((WLMessageProducer)ProducerProxy.this.producer, message, n, n2, l, proxyProducerSendRequest);
                return null;
            }
        });
    }

    synchronized void close() throws JMSException {
        this.unregister();
        this.parent.remove(this.serviceId);
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                if (ProducerProxy.this.producer != null) {
                    ProducerProxy.this.producer.close();
                }
                ProducerProxy.this.producer = null;
                return null;
            }
        });
    }

    void unregister() {
        this.getTransport().unregisterService(this.serviceId);
    }

    void remove(long l) {
    }

    public String toString() {
        return this.producer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendAsync(ProxyProducerSendRequest proxyProducerSendRequest, ReceivedTwoWay receivedTwoWay) {
        proxyProducerSendRequest.setReceivedTwoWay(receivedTwoWay);
        proxyProducerSendRequest.setProducerProxy(this);
        ProxyMessageImpl proxyMessageImpl = proxyProducerSendRequest.getMessage();
        ProxyDestinationImpl proxyDestinationImpl = proxyProducerSendRequest.getDestination();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("SendAsync() starts, destination on the request = " + proxyDestinationImpl + " destination on the message = " + proxyMessageImpl.getDestination());
        }
        Destination destination = null;
        String string = null;
        try {
            if (this.producer instanceof WLMessageProducer) {
                try {
                    string = ((WLMessageProducer)this.producer).getUnitOfOrder();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                if (proxyMessageImpl.propertyExists("JMS_BEA_UnitOfOrder")) {
                    ((WLMessageProducer)this.producer).setUnitOfOrder((String)proxyMessageImpl.getProperty("JMS_BEA_UnitOfOrder"));
                    proxyMessageImpl.removeProperty("JMS_BEA_UnitOfOrder");
                }
            }
            Message message = this.createJMSMessage(proxyMessageImpl);
            if (proxyDestinationImpl != null) {
                destination = proxyDestinationImpl.getJMSDestination();
                if (destination != null) {
                    this.sendAsync(proxyProducerSendRequest, destination, message, proxyMessageImpl.getDeliveryMode(), proxyMessageImpl.getPriority(), proxyMessageImpl.getExpiration());
                } else {
                    proxyProducerSendRequest.onException(new JMSException("Destination not found"));
                }
            } else {
                this.sendAsync(proxyProducerSendRequest, message, proxyMessageImpl.getDeliveryMode(), proxyMessageImpl.getPriority(), proxyMessageImpl.getExpiration());
            }
        }
        catch (Throwable throwable) {
            proxyProducerSendRequest.onException(throwable);
        }
        finally {
            if (this.producer instanceof WLMessageProducer) {
                try {
                    ((WLMessageProducer)this.producer).setUnitOfOrder(string);
                }
                catch (JMSException jMSException) {}
            }
        }
    }

    public void receiveCompletion(ProxyProducerSendRequest proxyProducerSendRequest, Object object, ReceivedTwoWay receivedTwoWay) {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("SendAsync() returned:  response = " + object);
        }
        if (object instanceof Throwable) {
            this.receiveException((Throwable)object, receivedTwoWay);
            return;
        }
        assert (object instanceof AsyncSendResponseInfo);
        AsyncSendResponseInfo asyncSendResponseInfo = (AsyncSendResponseInfo)object;
        MarshalWritable marshalWritable = null;
        try {
            marshalWritable = this.setupResponse(asyncSendResponseInfo, asyncSendResponseInfo.getMessage(), proxyProducerSendRequest.getMessage());
            if (asyncSendResponseInfo.getAsyncFlowControlTime() != 0L) {
                ((ProxyProducerSendResponse)marshalWritable).setFlowControlTime(asyncSendResponseInfo.getAsyncFlowControlTime());
            }
        }
        catch (JMSException jMSException) {
            marshalWritable = new TransportError(jMSException);
        }
        this.sendResult(receivedTwoWay, marshalWritable);
    }

    private void sendResult(final ReceivedTwoWay receivedTwoWay, final MarshalWritable marshalWritable) {
        try {
            JMSSecurityHelper.getJMSSecurityHelper();
            JMSSecurityHelper.doAs(JMSSecurityHelper.getAnonymousSubject(), new PrivilegedExceptionAction(){

                public Object run() {
                    receivedTwoWay.send(marshalWritable);
                    return receivedTwoWay;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void receiveException(Throwable throwable, ReceivedTwoWay receivedTwoWay) {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("SendAsync() failed:  throwable = " + throwable);
        }
        this.sendResult(receivedTwoWay, new TransportError(throwable));
    }

    private Message createJMSMessage(ProxyMessageImpl proxyMessageImpl) throws JMSException {
        Session session = ((SessionProxy)this.getParent()).getSession();
        byte by = proxyMessageImpl.getType();
        TextMessage textMessage = null;
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            switch (by) {
                case 2: {
                    JMSDebug.JMSDotNetProxy.debug("Sending header message");
                    break;
                }
                case 6: {
                    JMSDebug.JMSDotNetProxy.debug("Sending text message");
                    break;
                }
                case 1: {
                    JMSDebug.JMSDotNetProxy.debug("Sending bytes message");
                    break;
                }
                case 3: {
                    JMSDebug.JMSDotNetProxy.debug("Sending map message");
                    break;
                }
                case 5: {
                    JMSDebug.JMSDotNetProxy.debug("Sending object message");
                    break;
                }
                case 4: {
                    JMSDebug.JMSDotNetProxy.debug("Sending text message");
                }
            }
        }
        if (proxyMessageImpl.propertyExists("JMS_BEA_UnitOfWork") || proxyMessageImpl.propertyExists("JMS_BEA_UnitOfWorkSequenceNumber") || proxyMessageImpl.propertyExists("JMS_BEA_IsUnitOfWorkEnd")) {
            throw new JMSException("Unit-of-Work is not supported for .NET client");
        }
        switch (by) {
            case 6: {
                textMessage = session.createTextMessage();
                ((ProxyTextMessageImpl)proxyMessageImpl).populateJMSMessage(textMessage);
                break;
            }
            case 1: {
                textMessage = session.createBytesMessage();
                ((ProxyBytesMessageImpl)proxyMessageImpl).populateJMSMessage((BytesMessage)textMessage);
                break;
            }
            case 3: {
                textMessage = session.createMapMessage();
                ((ProxyMapMessageImpl)proxyMessageImpl).populateJMSMessage((MapMessage)textMessage);
                break;
            }
            case 5: {
                textMessage = session.createStreamMessage();
                ((ProxyStreamMessageImpl)proxyMessageImpl).populateJMSMessage((StreamMessage)textMessage);
                break;
            }
            case 4: {
                textMessage = session.createObjectMessage();
                ((ProxyObjectMessageImpl)proxyMessageImpl).populateJMSMessage((ObjectMessage)textMessage);
                break;
            }
            case 2: {
                textMessage = session.createMessage();
                ((ProxyHdrMessageImpl)proxyMessageImpl).populateJMSMessage((Message)textMessage);
            }
        }
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Message = " + textMessage);
        }
        return textMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MarshalWritable sendSync(ProxyProducerSendRequest proxyProducerSendRequest) throws JMSException {
        ProxyProducerSendResponse proxyProducerSendResponse;
        ProxyMessageImpl proxyMessageImpl = proxyProducerSendRequest.getMessage();
        ProxyDestinationImpl proxyDestinationImpl = proxyProducerSendRequest.getDestination();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("SendSync() starts, destination on the request = " + proxyDestinationImpl + " destiantion on the message = " + proxyMessageImpl.getDestination());
        }
        Destination destination = null;
        try {
            if (this.producer instanceof WLMessageProducer) {
                ((WLMessageProducer)this.producer).setUnitOfOrder((String)proxyMessageImpl.getProperty("JMS_BEA_UnitOfOrder"));
                proxyMessageImpl.removeProperty("JMS_BEA_UnitOfOrder");
            }
            Message message = this.createJMSMessage(proxyMessageImpl);
            if (proxyDestinationImpl != null) {
                destination = proxyDestinationImpl.getJMSDestination();
                if (destination != null) {
                    this.send(destination, message, proxyMessageImpl.getDeliveryMode(), proxyMessageImpl.getPriority(), proxyMessageImpl.getExpiration());
                    ProxyProducerSendResponse proxyProducerSendResponse2 = this.setupResponse(null, message, proxyMessageImpl);
                    return proxyProducerSendResponse2;
                }
                TransportError transportError = new TransportError("Destination not found", false);
                return transportError;
            }
            this.send(message, proxyMessageImpl.getDeliveryMode(), proxyMessageImpl.getPriority(), proxyMessageImpl.getExpiration());
            proxyProducerSendResponse = this.setupResponse(null, message, proxyMessageImpl);
        }
        catch (JMSException jMSException) {
            TransportError transportError = new TransportError(jMSException);
            return transportError;
        }
        finally {
            if (this.producer instanceof WLMessageProducer) {
                try {
                    ((WLMessageProducer)this.producer).setUnitOfOrder(null);
                }
                catch (JMSException jMSException) {}
            }
        }
        return proxyProducerSendResponse;
    }

    private ProxyProducerSendResponse setupResponse(AsyncSendResponseInfo asyncSendResponseInfo, Message message, ProxyMessageImpl proxyMessageImpl) throws JMSException {
        boolean bl;
        int n;
        int n2;
        int n3;
        ProxyProducerSendResponse proxyProducerSendResponse;
        JMSMessageId jMSMessageId;
        if (asyncSendResponseInfo != null) {
            jMSMessageId = ((MessageImpl)asyncSendResponseInfo.getMessage()).getId();
            proxyProducerSendResponse = new ProxyProducerSendResponse(jMSMessageId.getSeed(), jMSMessageId.getCounter());
        } else if (message instanceof WLMessage && !((MessageImpl)message).isOldMessage()) {
            jMSMessageId = ((MessageImpl)asyncSendResponseInfo.getMessage()).getId();
            proxyProducerSendResponse = new ProxyProducerSendResponse(jMSMessageId.getSeed(), jMSMessageId.getCounter());
        } else {
            proxyProducerSendResponse = new ProxyProducerSendResponse(message.getJMSMessageID());
        }
        proxyProducerSendResponse.setTimestamp(message.getJMSTimestamp());
        proxyProducerSendResponse.setExpirationTime(message.getJMSExpiration());
        if (asyncSendResponseInfo == null) {
            n3 = message.getJMSPriority();
            n2 = message.getJMSDeliveryMode();
            n = 0;
            bl = false;
        } else {
            n3 = asyncSendResponseInfo.getPriority();
            n2 = asyncSendResponseInfo.getDeliveryMode();
            n = asyncSendResponseInfo.getRedeliveryLimit();
            bl = asyncSendResponseInfo.isDispatchOneWay();
        }
        if (bl || n2 != proxyMessageImpl.getDeliveryMode()) {
            proxyProducerSendResponse.setDeliveryMode(n2);
        }
        if (bl || n3 != proxyMessageImpl.getPriority()) {
            proxyProducerSendResponse.setPriority(n3);
        }
        if (message instanceof WLMessage) {
            if (message.propertyExists("JMS_BEA_DeliveryTime")) {
                proxyProducerSendResponse.setDeliveryTime(message.getLongProperty("JMS_BEA_DeliveryTime"));
            }
            if (message.propertyExists("JMS_BEA_RedeliveryLimit") && message.getIntProperty("JMS_BEA_RedeliveryLimit") != 0) {
                proxyProducerSendResponse.setRedeliveryLimit(message.getIntProperty("JMS_BEA_RedeliveryLimit"));
            } else if (n != 0) {
                proxyProducerSendResponse.setRedeliveryLimit(n);
            }
        }
        return proxyProducerSendResponse;
    }

    public final void invoke(ReceivedTwoWay receivedTwoWay) {
        if (this.isShutdown()) {
            receivedTwoWay.send(new TransportError(new JMSException("The JMS service is shutting down")));
            return;
        }
        MarshalReadable marshalReadable = receivedTwoWay.getRequest();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("invoke():  code = " + marshalReadable.getMarshalTypeCode() + " request = " + marshalReadable);
        }
        MarshalWritable marshalWritable = null;
        try {
            switch (marshalReadable.getMarshalTypeCode()) {
                case 25: {
                    if (this.wlAsyncSession != null) {
                        this.sendAsync((ProxyProducerSendRequest)marshalReadable, receivedTwoWay);
                        return;
                    }
                    marshalWritable = this.sendSync((ProxyProducerSendRequest)marshalReadable);
                    break;
                }
                case 22: {
                    this.close();
                    marshalWritable = ProxyVoidResponse.THE_ONE;
                    break;
                }
                default: {
                    marshalWritable = new TransportError("Invalid MarshalReadableType : " + marshalReadable.getMarshalTypeCode(), false);
                    break;
                }
            }
        }
        catch (JMSException jMSException) {
            marshalWritable = new TransportError(jMSException);
        }
        receivedTwoWay.send(marshalWritable);
    }

    public void onPeerGone(TransportError transportError) {
    }

    public void onShutdown() {
    }

    public void onUnregister() {
    }

    public Transport getTransport() {
        return this.parent.getTransport();
    }

    InitialContextProxy getContext() {
        return this.parent.getContext();
    }

    public AbstractSubject getSubject() {
        return this.parent.getSubject();
    }

    static {
        String string = null;
        boolean bl = true;
        try {
            string = System.getProperty("weblogic.jms.dotnet.SendAsync");
            if (string != null) {
                bl = Boolean.valueOf(string);
            }
            if (!bl) {
                System.err.println("\n\nweblogic.jms.dotnet.proxy.internal.ProducerProxy -Dweblogic.jms.dotnet.SendAsync=" + bl);
            }
        }
        catch (Throwable throwable) {
            if (string != null) {
                System.err.println("\n\nproblem processing -Dweblogic.jms.dotnet.SendAsync=" + string);
            }
            throwable.printStackTrace();
        }
        USE_ASYNC = bl;
    }
}

