/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.internal;

import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSession;
import weblogic.jms.client.MMessageListener;
import weblogic.jms.client.MessageWrapper;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.dotnet.proxy.internal.BaseProxy;
import weblogic.jms.dotnet.proxy.internal.ConnectionProxy;
import weblogic.jms.dotnet.proxy.internal.ConsumerProxy;
import weblogic.jms.dotnet.proxy.internal.InitialContextProxy;
import weblogic.jms.dotnet.proxy.internal.ProducerProxy;
import weblogic.jms.dotnet.proxy.protocol.ProxyConsumerCreateRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyConsumerCreateResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxyDestinationCreateRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyDestinationCreateResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxyDestinationImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyProducerCreateRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyProducerCreateResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxyPushMessageListRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyPushMessageRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyRemoveSubscriptionRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxySessionAcknowledgeRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxySessionCloseRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxySessionRecoverRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxySessionRecoverResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxySessionWindowTurnRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyVoidResponse;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.ReceivedOneWay;
import weblogic.jms.dotnet.transport.ReceivedTwoWay;
import weblogic.jms.dotnet.transport.SendHandlerOneWay;
import weblogic.jms.dotnet.transport.ServiceOneWay;
import weblogic.jms.dotnet.transport.ServiceTwoWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.extensions.WLAsyncSession;
import weblogic.security.subject.AbstractSubject;

public class SessionProxy
extends BaseProxy
implements ServiceTwoWay,
ServiceOneWay,
MMessageListener {
    private Session session;
    private int ackMode;
    private final long sessionMsgListenerServiceId;
    private WLAsyncSession wlAsyncSession;
    private WLSessionImpl wlSessionImpl;
    private HashSet<Long> serviceIds = new HashSet();
    private static final int MAX_PUSH_COUNT = Integer.MAX_VALUE;

    protected SessionProxy(long l, ConnectionProxy connectionProxy, Session session, int n, long l2) {
        super(l, connectionProxy);
        this.session = session;
        this.ackMode = n;
        this.sessionMsgListenerServiceId = l2;
        if (session instanceof WLAsyncSession) {
            this.wlAsyncSession = (WLAsyncSession)session;
            this.wlSessionImpl = (WLSessionImpl)session;
            this.wlSessionImpl.setMMessageListener(this);
        } else {
            this.wlAsyncSession = null;
            this.wlSessionImpl = null;
        }
    }

    public final String toString() {
        return this.session.toString();
    }

    boolean getTransacted() throws JMSException {
        return this.session.getTransacted();
    }

    final int getAcknowledgeMode() {
        return this.ackMode;
    }

    private final void unsubscribe(final String string) throws JMSException {
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws JMSException {
                SessionProxy sessionProxy = SessionProxy.this;
                synchronized (sessionProxy) {
                    ((TopicSession)SessionProxy.this.session).unsubscribe(string);
                }
                return null;
            }
        });
    }

    private final TemporaryQueue createTemporaryQueue(String string) throws JMSException {
        throw new JMSException("createTemporaryQueue() is not supported");
    }

    private final TemporaryTopic createTemporaryTopic(String string) throws JMSException {
        throw new JMSException("createTemporaryTopic() is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister() {
        this.getTransport().unregisterService(this.serviceId);
        SessionProxy sessionProxy = this;
        synchronized (sessionProxy) {
            for (long l : this.serviceIds) {
                this.getTransport().unregisterService(l);
            }
            this.serviceIds.clear();
        }
    }

    private final void close(long l) throws JMSException {
        this.closeInner(true, l);
    }

    final void close() throws JMSException {
        this.closeInner(false, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeInner(final boolean bl, final long l) throws JMSException {
        SessionProxy sessionProxy = this;
        synchronized (sessionProxy) {
            if ((this.state & 1) != 0) {
                return;
            }
            this.state = 1;
        }
        this.unregister();
        this.parent.remove(this.serviceId);
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws JMSException {
                SessionProxy sessionProxy = SessionProxy.this;
                synchronized (sessionProxy) {
                    if (bl && SessionProxy.this.wlSessionImpl != null) {
                        SessionProxy.this.wlSessionImpl.close(l);
                    } else {
                        SessionProxy.this.session.close();
                    }
                    return null;
                }
            }
        });
    }

    private final MarshalWritable createConsumer(final ProxyConsumerCreateRequest proxyConsumerCreateRequest) throws JMSException {
        final ProxyDestinationImpl proxyDestinationImpl = proxyConsumerCreateRequest.getDestination();
        String string = proxyConsumerCreateRequest.getClientId();
        final String string2 = proxyConsumerCreateRequest.getName();
        MessageConsumer messageConsumer = null;
        String string3 = proxyConsumerCreateRequest.getSelector();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Creating consumer on " + proxyDestinationImpl.getJMSDestination() + " selector = " + string3 + " noLocal = " + proxyConsumerCreateRequest.getNoLocal() + " name = " + string2);
        }
        messageConsumer = string2 == null ? (MessageConsumer)JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws JMSException {
                SessionProxy sessionProxy = SessionProxy.this;
                synchronized (sessionProxy) {
                    return SessionProxy.this.session.createConsumer(proxyDestinationImpl.getJMSDestination(), proxyConsumerCreateRequest.getSelector(), proxyConsumerCreateRequest.getNoLocal());
                }
            }
        }) : (MessageConsumer)JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws JMSException {
                SessionProxy sessionProxy = SessionProxy.this;
                synchronized (sessionProxy) {
                    return SessionProxy.this.session.createDurableSubscriber((Topic)proxyDestinationImpl.getJMSDestination(), string2, proxyConsumerCreateRequest.getSelector(), proxyConsumerCreateRequest.getNoLocal());
                }
            }
        });
        long l = this.getTransport().allocateServiceID();
        ConsumerProxy consumerProxy = new ConsumerProxy(l, this, messageConsumer);
        this.getTransport().registerService(l, consumerProxy);
        this.addServiceId(l);
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Created consumer: id = " + l);
        }
        return new ProxyConsumerCreateResponse(l);
    }

    private final MarshalWritable createProducer(ProxyProducerCreateRequest proxyProducerCreateRequest) throws JMSException {
        Destination destination;
        ProxyDestinationImpl proxyDestinationImpl = proxyProducerCreateRequest.getDestination();
        Destination destination2 = destination = proxyDestinationImpl == null ? null : proxyDestinationImpl.getJMSDestination();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Creating producer on " + destination);
        }
        MessageProducer messageProducer = (MessageProducer)JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws JMSException {
                SessionProxy sessionProxy = SessionProxy.this;
                synchronized (sessionProxy) {
                    return SessionProxy.this.session.createProducer(destination);
                }
            }
        });
        long l = this.getTransport().allocateServiceID();
        ProducerProxy producerProxy = new ProducerProxy(l, this, messageProducer, proxyDestinationImpl);
        this.getTransport().registerService(l, producerProxy);
        this.addServiceId(l);
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Created producer: id = " + l);
        }
        return new ProxyProducerCreateResponse(l, messageProducer);
    }

    private void acknowledgeAsync(ProxySessionAcknowledgeRequest proxySessionAcknowledgeRequest, ReceivedTwoWay receivedTwoWay) {
        final ProxySessionAcknowledgeRequest proxySessionAcknowledgeRequest2 = proxySessionAcknowledgeRequest;
        proxySessionAcknowledgeRequest2.setReceivedTwoWay(receivedTwoWay);
        proxySessionAcknowledgeRequest2.setSessionProxy(this);
        try {
            if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                JMSDebug.JMSDotNetProxy.debug("AcknowledgeAsync(): transacted=" + this.session.getTransacted() + " doCommit=" + proxySessionAcknowledgeRequest2.isDoCommit() + " seq=" + proxySessionAcknowledgeRequest2.getSequenceNumber());
            }
            JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws JMSException {
                    SessionProxy sessionProxy = SessionProxy.this;
                    synchronized (sessionProxy) {
                        SessionProxy.this.wlAsyncSession.acknowledgeAsync(proxySessionAcknowledgeRequest2, proxySessionAcknowledgeRequest2);
                    }
                    return null;
                }
            });
        }
        catch (JMSException jMSException) {
            proxySessionAcknowledgeRequest2.onException(jMSException);
        }
    }

    public void receiveCompletion(ProxySessionAcknowledgeRequest proxySessionAcknowledgeRequest, Object object, ReceivedTwoWay receivedTwoWay) {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("AcknowledgeAsync() returned:  response = " + object);
        }
        if (object instanceof Throwable) {
            this.receiveException((Throwable)object, receivedTwoWay);
            return;
        }
        ProxyVoidResponse proxyVoidResponse = ProxyVoidResponse.THE_ONE;
        receivedTwoWay.send(proxyVoidResponse);
    }

    public void receiveException(Throwable throwable, ReceivedTwoWay receivedTwoWay) {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("AcknowledgeAsync() failed:  throwable = " + throwable);
        }
        receivedTwoWay.send(new TransportError(throwable));
    }

    private MarshalWritable acknowledgeSync(final ProxySessionAcknowledgeRequest proxySessionAcknowledgeRequest) throws JMSException {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("AcknowledgeSync(): transacted=" + this.session.getTransacted() + " doCommit=" + proxySessionAcknowledgeRequest.isDoCommit() + " seq=" + proxySessionAcknowledgeRequest.getSequenceNumber());
        }
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws JMSException {
                SessionProxy sessionProxy = SessionProxy.this;
                synchronized (sessionProxy) {
                    if (proxySessionAcknowledgeRequest.isDoCommit()) {
                        if (SessionProxy.this.wlSessionImpl != null) {
                            SessionProxy.this.wlSessionImpl.commit(proxySessionAcknowledgeRequest.getSequenceNumber());
                        } else {
                            SessionProxy.this.session.commit();
                        }
                    } else {
                        throw new AssertionError((Object)"not implemented");
                    }
                }
                return null;
            }
        });
        return ProxyVoidResponse.THE_ONE;
    }

    private MarshalWritable recover(final ProxySessionRecoverRequest proxySessionRecoverRequest) throws JMSException {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("recover(): transacted=" + this.session.getTransacted() + " doRollback=" + proxySessionRecoverRequest.isDoRollback() + " seq=" + proxySessionRecoverRequest.getSequenceNumber());
        }
        int n = (Integer)JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws JMSException {
                SessionProxy sessionProxy = SessionProxy.this;
                synchronized (sessionProxy) {
                    int n = 0;
                    if (SessionProxy.this.wlSessionImpl != null) {
                        n = proxySessionRecoverRequest.isDoRollback() ? SessionProxy.this.wlSessionImpl.rollback(proxySessionRecoverRequest.getSequenceNumber()) : SessionProxy.this.wlSessionImpl.recover(proxySessionRecoverRequest.getSequenceNumber());
                        return new Integer(n);
                    }
                    if (proxySessionRecoverRequest.isDoRollback()) {
                        SessionProxy.this.session.rollback();
                    } else {
                        SessionProxy.this.session.recover();
                    }
                    return new Integer(n);
                }
            }
        });
        return new ProxySessionRecoverResponse(n);
    }

    private synchronized void windowTurn(ProxySessionWindowTurnRequest proxySessionWindowTurnRequest) {
        if (this.wlSessionImpl != null) {
            try {
                this.wlSessionImpl.removePendingWTMessage(proxySessionWindowTurnRequest.getSequenceNumber());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final MarshalWritable close(ProxySessionCloseRequest proxySessionCloseRequest) throws JMSException {
        this.close(proxySessionCloseRequest.getSequenceNumber());
        return ProxyVoidResponse.THE_ONE;
    }

    private final MarshalWritable createDestination(ProxyDestinationCreateRequest proxyDestinationCreateRequest) throws JMSException {
        final int n = proxyDestinationCreateRequest.getDestinationType();
        final boolean bl = proxyDestinationCreateRequest.isTemporary();
        final String string = proxyDestinationCreateRequest.getDestinationName();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("CreateDestination(): type = " + (n == 1 ? "Queue" : "Topic") + " name =  " + string + " isTemp = " + bl);
        }
        Destination destination = (Destination)JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws JMSException {
                SessionProxy sessionProxy = SessionProxy.this;
                synchronized (sessionProxy) {
                    if (n == 1) {
                        if (bl) {
                            return SessionProxy.this.createTemporaryQueue(string);
                        }
                        return SessionProxy.this.session.createQueue(string);
                    }
                    if (n == 2) {
                        if (bl) {
                            return SessionProxy.this.createTemporaryTopic(string);
                        }
                        return SessionProxy.this.session.createTopic(string);
                    }
                }
                return null;
            }
        });
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("CreateDestination(): found destination = " + destination);
        }
        return new ProxyDestinationCreateResponse(new ProxyDestinationImpl(string, destination));
    }

    private final ProxyPushMessageRequest createPush(MessageWrapper messageWrapper, boolean bl) throws JMSException {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("CreatePush:  Pushing  msg=" + messageWrapper.getMessageImpl() + " seq=" + messageWrapper.getSequence() + " gen=" + messageWrapper.getGeneration());
        }
        ProxyMessageImpl proxyMessageImpl = ConsumerProxy.createProxyMessageImpl(messageWrapper.getMessageImpl());
        proxyMessageImpl.setSequenceNumber(messageWrapper.getSequence());
        proxyMessageImpl.setPipelineGeneration(messageWrapper.getGeneration());
        proxyMessageImpl.setDeliveryCount(messageWrapper.getDeliveryCount());
        if (messageWrapper.getDeliveryCount() > 1) {
            proxyMessageImpl.setRedelivered(true);
        }
        return new ProxyPushMessageRequest(messageWrapper.getProxyId(), proxyMessageImpl, bl);
    }

    private final void pushMany(final ProxyPushMessageListRequest proxyPushMessageListRequest) throws JMSException {
        final SendHandlerOneWay sendHandlerOneWay = this.getTransport().createOneWay(this.sessionMsgListenerServiceId, this.sessionMsgListenerServiceId);
        JMSSecurityHelper.doAs((AbstractSubject)anonymous, new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                sendHandlerOneWay.send(proxyPushMessageListRequest);
                return null;
            }
        });
    }

    public final void onMessages(MessageWrapper messageWrapper, int n) {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Starting onMessages");
        }
        Throwable throwable = null;
        try {
            MessageWrapper messageWrapper2 = messageWrapper;
            while (messageWrapper2 != null) {
                int n2 = 0;
                ProxyPushMessageListRequest proxyPushMessageListRequest = new ProxyPushMessageListRequest(n);
                while (messageWrapper2 != null) {
                    boolean bl = messageWrapper2.next() == null;
                    proxyPushMessageListRequest.add(this.createPush(messageWrapper2, bl));
                    if (++n2 == Integer.MAX_VALUE) {
                        messageWrapper2 = messageWrapper2.next();
                        break;
                    }
                    messageWrapper2 = messageWrapper2.next();
                }
                this.pushMany(proxyPushMessageListRequest);
            }
        }
        catch (JMSException jMSException) {
            throwable = jMSException;
            throw new RuntimeException(jMSException);
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
            throw runtimeException;
        }
        catch (Error error) {
            throwable = error;
            throw error;
        }
        finally {
            if (throwable != null && JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                JMSDebug.JMSDotNetProxy.debug("should never happen " + throwable);
                throwable.printStackTrace();
            }
        }
    }

    public final void invoke(ReceivedOneWay receivedOneWay) {
        if (this.isShutdown()) {
            return;
        }
        MarshalReadable marshalReadable = receivedOneWay.getRequest();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("invoke(): one-way:  code = " + marshalReadable.getMarshalTypeCode() + " request = " + marshalReadable);
        }
        switch (marshalReadable.getMarshalTypeCode()) {
            case 49: {
                this.windowTurn((ProxySessionWindowTurnRequest)marshalReadable);
                break;
            }
            default: {
                if (!JMSDebug.JMSDotNetProxy.isDebugEnabled()) break;
                JMSDebug.JMSDotNetProxy.debug("DEBUG: should never reach here, Session one-way: Unexpected type code" + marshalReadable.getMarshalTypeCode());
            }
        }
    }

    private synchronized void addServiceId(long l) throws JMSException {
        this.checkShutdownOrClosed("The session has been closed");
        this.serviceIds.add(l);
    }

    synchronized void remove(long l) {
        this.serviceIds.remove(l);
    }

    public final void invoke(ReceivedTwoWay receivedTwoWay) {
        if (this.isShutdown()) {
            receivedTwoWay.send(new TransportError(new JMSException("The JMS service is shutting down")));
            return;
        }
        MarshalReadable marshalReadable = receivedTwoWay.getRequest();
        MarshalWritable marshalWritable = ProxyVoidResponse.THE_ONE;
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Invoking: code = " + marshalReadable.getMarshalTypeCode() + " request = " + marshalReadable);
        }
        try {
            switch (marshalReadable.getMarshalTypeCode()) {
                case 13: {
                    marshalWritable = this.createConsumer((ProxyConsumerCreateRequest)marshalReadable);
                    break;
                }
                case 20: {
                    marshalWritable = this.createDestination((ProxyDestinationCreateRequest)marshalReadable);
                    break;
                }
                case 23: {
                    marshalWritable = this.createProducer((ProxyProducerCreateRequest)marshalReadable);
                    break;
                }
                case 32: {
                    marshalWritable = this.recover((ProxySessionRecoverRequest)marshalReadable);
                    break;
                }
                case 27: {
                    this.unsubscribe(((ProxyRemoveSubscriptionRequest)marshalReadable).getName());
                    marshalWritable = ProxyVoidResponse.THE_ONE;
                    break;
                }
                case 28: {
                    if (this.wlAsyncSession != null && !((ProxySessionAcknowledgeRequest)marshalReadable).isDoCommit()) {
                        this.acknowledgeAsync((ProxySessionAcknowledgeRequest)marshalReadable, receivedTwoWay);
                        return;
                    }
                    marshalWritable = this.acknowledgeSync((ProxySessionAcknowledgeRequest)marshalReadable);
                    break;
                }
                case 29: {
                    this.close((ProxySessionCloseRequest)marshalReadable);
                    marshalWritable = ProxyVoidResponse.THE_ONE;
                    break;
                }
                default: {
                    marshalWritable = new TransportError("Invalid MarshalReadableType : " + marshalReadable.getMarshalTypeCode(), false);
                    break;
                }
            }
        }
        catch (JMSException jMSException) {
            marshalWritable = new TransportError(jMSException);
        }
        receivedTwoWay.send(marshalWritable);
    }

    public void onPeerGone(TransportError transportError) {
    }

    public void onShutdown() {
    }

    public void onUnregister() {
    }

    public Transport getTransport() {
        return this.parent.getTransport();
    }

    InitialContextProxy getContext() {
        return this.parent.getContext();
    }

    Session getSession() {
        return this.session;
    }

    AbstractSubject getSubject() {
        return this.parent.getSubject();
    }
}

