/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class MarshalBitMask {
    private static final int VERSION_MASK = 255;
    private static final int HAS_EXTENSION = Integer.MIN_VALUE;
    private int[] masks;
    private int version;
    static final boolean debug = false;

    public MarshalBitMask(int n) {
        this.version = n;
        this.masks = new int[1];
        this.masks[0] = n;
    }

    public final int getVersion() {
        return this.version;
    }

    public final boolean isSet(int n) {
        int n2 = this.getIndex(n);
        int n3 = this.getPosition(n, n2);
        if (n2 >= this.masks.length) {
            return false;
        }
        int n4 = this.masks[n2];
        return (n4 & 1 << n3) != 0;
    }

    public final void setBit(int n) {
        int n2 = this.getIndex(n);
        if (n2 >= this.masks.length) {
            this.expand(n2);
        }
        int n3 = this.getPosition(n, n2);
        int n4 = n2;
        this.masks[n4] = this.masks[n4] | 1 << n3;
    }

    private int getIndex(int n) {
        return (n + 7) / 31;
    }

    private int getPosition(int n, int n2) {
        return n + 7 - n2 * 31;
    }

    private void expand(int n) {
        int n2;
        int[] nArray = new int[n + 1];
        for (n2 = 0; n2 < this.masks.length - 1; ++n2) {
            nArray[n2] = this.masks[n2];
        }
        nArray[this.masks.length - 1] = this.masks[this.masks.length - 1] | Integer.MIN_VALUE;
        for (n2 = this.masks.length; n2 < n - 1; ++n2) {
            nArray[n2] = Integer.MIN_VALUE;
        }
        this.masks = nArray;
    }

    public MarshalBitMask() {
    }

    public void marshal(MarshalWriter marshalWriter) {
        for (int n : this.masks) {
            marshalWriter.writeInt(n);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        this.masks = new int[1];
        int n = 0;
        while (((this.masks[n++] = marshalReader.readInt()) & Integer.MIN_VALUE) != 0) {
            this.expand(n);
        }
        this.version = this.masks[0] & 0xFF;
    }

    private void debug(String string) {
        System.out.println("[MarshalBitMask]: " + string);
    }
}

