/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveMap
implements Map<String, Object>,
MarshalWritable,
MarshalReadable {
    private static final int EXTVERSION = 1;
    private MarshalBitMask versionFlags;
    private static final short TYPENULL = 99;
    private static final short TYPESTRING = 102;
    private static final short TYPEBOOLEAN = 103;
    private static final short TYPEINTEGER = 104;
    private static final short TYPELONG = 105;
    private static final short TYPEBYTE = 106;
    private static final short TYPESHORT = 107;
    private static final short TYPEFLOAT = 108;
    private static final short TYPEDOUBLE = 109;
    private static final short TYPECHARACTER = 110;
    private static final short TYPEBYTEARRAY = 111;
    private static final short TYPEBIGSTRING = 112;
    private Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Object get(Object object) {
        return this.map.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(String string, Object object) {
        this.checkValidType(object);
        return this.map.put(string, object);
    }

    private void checkValidType(Object object) {
        if (!(object == null || object instanceof byte[] || object instanceof String || object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double)) {
            throw new IllegalArgumentException("Passed value object (Class = " + object.getClass().getName() + ") is not allowed primitive type");
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        if (map == null || !map.isEmpty()) {
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Object remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public int getMarshalTypeCode() {
        return 0;
    }

    @Override
    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeInt(this.map.size());
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            marshalWriter.writeShort((short)102);
            marshalWriter.writeString(entry.getKey());
            if (entry.getValue() == null) {
                marshalWriter.writeShort((short)99);
                continue;
            }
            if (entry.getValue() instanceof String) {
                marshalWriter.writeShort((short)102);
                marshalWriter.writeString((String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                marshalWriter.writeShort((short)104);
                marshalWriter.writeInt((Integer)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Long) {
                marshalWriter.writeShort((short)105);
                marshalWriter.writeLong((Long)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof byte[]) {
                marshalWriter.writeShort((short)111);
                byte[] byArray = (byte[])entry.getValue();
                marshalWriter.writeInt(byArray.length);
                marshalWriter.write(byArray, 0, byArray.length);
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                marshalWriter.writeShort((short)103);
                marshalWriter.writeBoolean((Boolean)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Byte) {
                marshalWriter.writeShort((short)106);
                marshalWriter.writeByte((Byte)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Short) {
                marshalWriter.writeShort((short)107);
                marshalWriter.writeShort((Short)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Float) {
                marshalWriter.writeShort((short)108);
                marshalWriter.writeFloat(((Float)entry.getValue()).floatValue());
                continue;
            }
            if (entry.getValue() instanceof Double) {
                marshalWriter.writeShort((short)109);
                marshalWriter.writeDouble((Double)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Character) {
                marshalWriter.writeShort((short)110);
                marshalWriter.writeChar(((Character)entry.getValue()).charValue());
                continue;
            }
            throw new IllegalArgumentException("Invalid value type " + entry.getValue().getClass().getName() + " found");
        }
    }

    @Override
    public void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        for (int i = marshalReader.readInt(); i != 0; --i) {
            String string = (String)this.readPrimitiveType(marshalReader);
            Object object = this.readPrimitiveType(marshalReader);
            this.map.put(string, object);
        }
    }

    private Object readPrimitiveType(MarshalReader marshalReader) {
        short s = marshalReader.readShort();
        switch (s) {
            case 99: {
                return null;
            }
            case 102: {
                return marshalReader.readString();
            }
            case 103: {
                return marshalReader.readBoolean();
            }
            case 104: {
                return marshalReader.readInt();
            }
            case 105: {
                return marshalReader.readLong();
            }
            case 106: {
                return marshalReader.readByte();
            }
            case 111: {
                int n = marshalReader.readInt();
                byte[] byArray = new byte[n];
                marshalReader.read(byArray, 0, n);
                return byArray;
            }
            case 107: {
                return marshalReader.readShort();
            }
            case 108: {
                return Float.valueOf(marshalReader.readFloat());
            }
            case 109: {
                return marshalReader.readDouble();
            }
            case 110: {
                return Character.valueOf(marshalReader.readChar());
            }
        }
        throw new IllegalArgumentException("Invalid value type code " + s + " found");
    }
}

