/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyMessageImpl;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyBytesMessageImpl
extends ProxyMessageImpl {
    private static final int EXTVERSION = 1;
    private static final int _HAS_DATA = 1;
    private PayloadStream payload;

    public ProxyBytesMessageImpl() {
    }

    public ProxyBytesMessageImpl(BytesMessage bytesMessage) throws JMSException {
        super((Message)bytesMessage);
        this.payload = ((BytesMessageImpl)bytesMessage).getPayload();
    }

    public byte getType() {
        return 1;
    }

    public void populateJMSMessage(BytesMessage bytesMessage) throws JMSException {
        super.populateJMSMessage((Message)bytesMessage);
        ((BytesMessageImpl)bytesMessage).setPayload(this.payload);
    }

    public String toString() {
        return "BytesMessage[" + this.getMessageID() + " payload = " + this.payload + "]";
    }

    public int getMarshalTypeCode() {
        return 36;
    }

    public void marshal(MarshalWriter marshalWriter) {
        super.marshal(marshalWriter);
        MarshalBitMask marshalBitMask = new MarshalBitMask(1);
        if (this.payload != null && this.payload.getLength() != 0) {
            marshalBitMask.setBit(1);
        }
        marshalBitMask.marshal(marshalWriter);
        if (marshalBitMask.isSet(1)) {
            try {
                this.payload.writeLengthAndData(marshalWriter.getDataOutputStream());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        super.unmarshal(marshalReader);
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        if (marshalBitMask.isSet(1)) {
            try {
                DataInput dataInput = marshalReader.getDataInputStream();
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)dataInput));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

