/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyRequest;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyConnectionCreateRequest
extends ProxyRequest {
    private static final int EXTVERSION = 1;
    private static final int _IS_XA = 1;
    private static final int _HAS_USER_NAME = 2;
    private static final int _HAS_PASSWORD = 3;
    private long listenerServiceId;
    private String userName;
    private String password;
    private boolean createXAConnection;

    public ProxyConnectionCreateRequest() {
    }

    public ProxyConnectionCreateRequest(long l, String string, String string2, boolean bl) {
        this.listenerServiceId = l;
        this.userName = string;
        this.password = string2;
        this.createXAConnection = bl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isCreateXAConnection() {
        return this.createXAConnection;
    }

    public long getListenerServiceId() {
        return this.listenerServiceId;
    }

    public int getMarshalTypeCode() {
        return 9;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.userName != null) {
            this.versionFlags.setBit(2);
        }
        if (this.password != null) {
            this.versionFlags.setBit(3);
        }
        if (this.createXAConnection) {
            this.versionFlags.setBit(1);
        }
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeLong(this.listenerServiceId);
        if (this.userName != null) {
            marshalWriter.writeString(this.userName);
        }
        if (this.password != null) {
            marshalWriter.writeString(this.password);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        this.listenerServiceId = marshalReader.readLong();
        if (this.versionFlags.isSet(2)) {
            this.userName = marshalReader.readString();
        }
        if (this.versionFlags.isSet(3)) {
            this.password = marshalReader.readString();
        }
        if (this.versionFlags.isSet(1)) {
            this.createXAConnection = true;
        }
    }
}

