/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyConnectionMetaDataImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyResponse;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public class ProxyConnectionCreateResponse
extends ProxyResponse {
    private static final int EXTVERSION = 1;
    private static final int _HAS_CLIENT_ID = 1;
    private long connectionId;
    private String clientId;
    private int acknowledgePolicy;
    private ProxyConnectionMetaDataImpl metadata;

    public ProxyConnectionCreateResponse(long l, String string, int n, ProxyConnectionMetaDataImpl proxyConnectionMetaDataImpl) {
        this.connectionId = l;
        this.clientId = string;
        this.acknowledgePolicy = n;
        this.metadata = proxyConnectionMetaDataImpl;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public ProxyConnectionCreateResponse() {
    }

    public int getMarshalTypeCode() {
        return 10;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.clientId != null) {
            this.versionFlags.setBit(1);
        }
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeLong(this.connectionId);
        if (this.clientId != null) {
            marshalWriter.writeString(this.clientId);
        }
        marshalWriter.writeInt(this.acknowledgePolicy);
        this.metadata.marshal(marshalWriter);
    }

    public void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        this.connectionId = marshalReader.readLong();
        if (this.versionFlags.isSet(1)) {
            this.clientId = marshalReader.readString();
        }
        this.acknowledgePolicy = marshalReader.readInt();
        this.metadata = new ProxyConnectionMetaDataImpl();
        this.metadata.unmarshal(marshalReader);
    }
}

