/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;

public class ProxyConnectionMetaDataImpl
implements MarshalReadable,
MarshalWritable,
ConnectionMetaData {
    private static final int EXTVERSION = 1;
    private static final int _HAS_PROVIDER_NAME = 1;
    private static final int _HAS_JMSSPEC_VERSION = 2;
    private MarshalBitMask versionFlags;
    private int majorVersion;
    private int minorVersion;
    private String providerName;
    private String version;
    private String propertyNames;
    private int providerMajorVersion;
    private int providerMinorVersion;
    private String providerVersion;

    public ProxyConnectionMetaDataImpl() {
    }

    public ProxyConnectionMetaDataImpl(ConnectionMetaData connectionMetaData) throws JMSException {
        this.versionFlags = new MarshalBitMask(1);
        this.majorVersion = connectionMetaData.getJMSMajorVersion();
        this.minorVersion = connectionMetaData.getJMSMinorVersion();
        this.providerName = connectionMetaData.getJMSProviderName();
        if (this.providerName != null) {
            this.versionFlags.setBit(1);
        }
        this.version = connectionMetaData.getJMSVersion();
        if (this.version != null) {
            this.versionFlags.setBit(2);
        }
        this.propertyNames = "";
        Enumeration enumeration = connectionMetaData.getJMSXPropertyNames();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (n++ > 0) {
                this.propertyNames = this.propertyNames + " ";
            }
            this.propertyNames = this.propertyNames + (String)enumeration.nextElement();
        }
        this.providerMajorVersion = connectionMetaData.getProviderMajorVersion();
        this.providerMinorVersion = connectionMetaData.getProviderMinorVersion();
        this.providerVersion = connectionMetaData.getProviderVersion();
    }

    public int getMarshalTypeCode() {
        return 50;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeInt(this.majorVersion);
        marshalWriter.writeInt(this.minorVersion);
        if (this.providerName != null) {
            marshalWriter.writeString(this.providerName);
        }
        if (this.version != null) {
            marshalWriter.writeString(this.version);
        }
        marshalWriter.writeString(this.propertyNames);
        marshalWriter.writeInt(this.providerMajorVersion);
        marshalWriter.writeInt(this.providerMinorVersion);
        marshalWriter.writeString(this.providerVersion);
    }

    public void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        this.majorVersion = marshalReader.readInt();
        this.minorVersion = marshalReader.readInt();
        if (this.versionFlags.isSet(1)) {
            this.providerName = marshalReader.readString();
        }
        if (this.versionFlags.isSet(2)) {
            this.version = marshalReader.readString();
        }
        this.propertyNames = marshalReader.readString();
        this.providerMajorVersion = marshalReader.readInt();
        this.providerMinorVersion = marshalReader.readInt();
        this.providerVersion = marshalReader.readString();
    }

    public String toString() {
        return "ProxyConnectionMetaData<JMS Spec. version=" + this.version + ", JMS spec. major version=" + this.majorVersion + ", JMS spec. minor ver.=" + this.minorVersion + " Vendor=" + this.providerName + " Version= " + this.providerVersion + ", Provider major version=" + this.providerMajorVersion + ", Provider minor version=" + this.providerMinorVersion + " PropertyNames=" + this.propertyNames + " >";
    }

    public int getJMSMajorVersion() throws JMSException {
        return this.majorVersion;
    }

    public int getJMSMinorVersion() throws JMSException {
        return this.minorVersion;
    }

    public String getJMSProviderName() throws JMSException {
        return this.providerName;
    }

    public String getJMSVersion() throws JMSException {
        return this.version;
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.propertyNames);
        return stringTokenizer;
    }

    public int getProviderMajorVersion() throws JMSException {
        return this.providerMajorVersion;
    }

    public int getProviderMinorVersion() throws JMSException {
        return this.providerMinorVersion;
    }

    public String getProviderVersion() throws JMSException {
        return this.providerVersion;
    }
}

