/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyResponse;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public class ProxyConsumerReceiveResponse
extends ProxyResponse {
    private static final int EXTVERSION = 1;
    private static final int _HAS_MESSAGE = 1;
    private ProxyMessageImpl message;

    public ProxyConsumerReceiveResponse(ProxyMessageImpl proxyMessageImpl) {
        this.message = proxyMessageImpl;
    }

    public final ProxyMessageImpl getMessage() {
        return this.message;
    }

    public ProxyConsumerReceiveResponse() {
    }

    public int getMarshalTypeCode() {
        return 17;
    }

    public void marshal(MarshalWriter marshalWriter) {
        MarshalBitMask marshalBitMask = new MarshalBitMask(1);
        if (this.message != null) {
            marshalBitMask.setBit(1);
        }
        marshalBitMask.marshal(marshalWriter);
        if (this.message != null) {
            marshalWriter.writeByte(this.message.getType());
            this.message.marshal(marshalWriter);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        if (marshalBitMask.isSet(1)) {
            byte by = marshalReader.readByte();
            this.message = ProxyMessageImpl.createMessageImpl(by);
            this.message.unmarshal(marshalReader);
        }
    }
}

