/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyRequest;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyConsumerSetListenerRequest
extends ProxyRequest {
    private static final int EXTVERSION = 1;
    private static final int _HAS_LISTENER = 1;
    private static final int _HAS_SEQUENCE_NUMBER = 2;
    private boolean hasListener;
    private long sequenceNumber = 0L;
    private long listenerServiceId;

    public ProxyConsumerSetListenerRequest(boolean bl, long l, long l2) {
        this.hasListener = bl;
        this.sequenceNumber = l2;
        this.listenerServiceId = l;
    }

    public boolean getHasListener() {
        return this.hasListener;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getListenerServiceId() {
        return this.listenerServiceId;
    }

    public ProxyConsumerSetListenerRequest() {
    }

    public int getMarshalTypeCode() {
        return 18;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.hasListener) {
            this.versionFlags.setBit(1);
        }
        if (this.sequenceNumber != 0L) {
            this.versionFlags.setBit(2);
        }
        this.versionFlags.marshal(marshalWriter);
        if (this.hasListener) {
            marshalWriter.writeLong(this.listenerServiceId);
        }
        if (this.sequenceNumber != 0L) {
            marshalWriter.writeLong(this.sequenceNumber);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        if (this.versionFlags.isSet(1)) {
            this.hasListener = true;
            this.listenerServiceId = marshalReader.readLong();
        }
        if (this.versionFlags.isSet(2)) {
            this.sequenceNumber = marshalReader.readLong();
        }
    }
}

