/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyRequest;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyDestinationCreateRequest
extends ProxyRequest {
    private String destinationName;
    private int destinationType;
    private boolean temporary;
    private static final int EXTVERSION = 1;
    private static final int _HAS_DESTINATION_TYPE = 1;
    private static final int _IS_TEMPORARY = 2;
    public static final int TYPE_QUEUE = 1;
    public static final int TYPE_TOPIC = 2;

    public ProxyDestinationCreateRequest(String string, int n, boolean bl) {
        this.destinationName = string;
        this.destinationType = n;
        this.temporary = bl;
    }

    public final String getDestinationName() {
        return this.destinationName;
    }

    public final void setDestinationName(String string) {
        this.destinationName = string;
    }

    public final int getDestinationType() {
        return this.destinationType;
    }

    public final boolean isTemporary() {
        return this.temporary;
    }

    public ProxyDestinationCreateRequest() {
    }

    public int getMarshalTypeCode() {
        return 20;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.destinationType != -1) {
            this.versionFlags.setBit(1);
        }
        if (this.temporary) {
            this.versionFlags.setBit(2);
        }
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeString(this.destinationName);
        if (this.destinationType != -1) {
            marshalWriter.writeInt(this.destinationType);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        this.destinationName = marshalReader.readString();
        if (marshalBitMask.isSet(1)) {
            this.destinationType = marshalReader.readInt();
        }
        this.temporary = marshalBitMask.isSet(2);
    }
}

