/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import java.io.Externalizable;
import java.io.IOException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;

public class ProxyDestinationImpl
implements MarshalReadable,
MarshalWritable {
    private static final int EXTVERSION = 1;
    private static final int _SERIALIZED_DESTINATION = 1;
    private static final int _HAS_CREATE_DESTINATION_ARG = 2;
    private static final int _IS_DISTRIBUTED_DESTINATION = 3;
    public static final byte TYPE_QUEUE = 1;
    public static final byte TYPE_TOPIC = 2;
    public static final byte TYPE_TEMP_QUEUE = 3;
    public static final byte TYPE_TEMP_TOPIC = 4;
    public transient Destination destination;
    private String name;
    private int type;
    private String createDestinationArgument;
    private boolean marshaled;
    private byte[] marshaledDestination;
    private boolean isDD;

    public ProxyDestinationImpl(String string, Destination destination) throws JMSException {
        this.setupDestination(destination);
    }

    public ProxyDestinationImpl(Destination destination) throws JMSException {
        this.setupDestination(destination);
    }

    private void setupDestination(Destination destination) throws JMSException {
        this.destination = destination;
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Destination = " + destination.getClass());
        }
        if (destination instanceof Externalizable) {
            if (destination instanceof DestinationImpl) {
                this.name = ((DestinationImpl)destination).getName();
                this.type = ((DestinationImpl)destination).getType();
                if (destination instanceof DistributedDestinationImpl) {
                    this.isDD = true;
                    this.createDestinationArgument = ((DistributedDestinationImpl)destination).getCreateDestinationArgument();
                } else {
                    this.createDestinationArgument = ((DestinationImpl)destination).getCreateDestinationArgument();
                }
            } else if (destination instanceof Queue) {
                this.name = ((Queue)destination).getQueueName();
                this.type = destination instanceof TemporaryQueue ? 4 : 1;
            } else if (destination instanceof Topic) {
                this.name = ((Topic)destination).getTopicName();
                this.type = destination instanceof TemporaryTopic ? 8 : 2;
            }
            this.marshaledDestination = ProxyUtil.marshalExternalizable((Externalizable)destination);
            this.marshaled = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public Destination getJMSDestination() {
        return this.destination;
    }

    public byte[] getMarshaledDestination() {
        return this.marshaledDestination;
    }

    private void unmarshalDestination() {
        BufferDataInputStream bufferDataInputStream = new BufferDataInputStream(null, this.marshaledDestination);
        this.destination = this.isDD ? new DistributedDestinationImpl() : new DestinationImpl();
        try {
            if (this.isDD) {
                ((DistributedDestinationImpl)this.destination).readExternal(bufferDataInputStream);
            } else {
                ((DestinationImpl)this.destination).readExternal(bufferDataInputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public ProxyDestinationImpl() {
    }

    public int getMarshalTypeCode() {
        return 41;
    }

    public void marshal(MarshalWriter marshalWriter) {
        MarshalBitMask marshalBitMask = new MarshalBitMask(1);
        if (this.marshaled) {
            marshalBitMask.setBit(1);
        }
        if (this.createDestinationArgument != null) {
            marshalBitMask.setBit(2);
        }
        if (this.isDD) {
            marshalBitMask.setBit(3);
        }
        marshalBitMask.marshal(marshalWriter);
        marshalWriter.writeString(this.name);
        marshalWriter.writeByte((byte)this.type);
        if (this.marshaled) {
            marshalWriter.writeInt(this.marshaledDestination.length);
            marshalWriter.write(this.marshaledDestination, 0, this.marshaledDestination.length);
        }
        if (this.createDestinationArgument != null) {
            marshalWriter.writeString(this.createDestinationArgument);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        this.marshaled = marshalBitMask.isSet(1);
        this.name = marshalReader.readString();
        this.type = marshalReader.readByte();
        this.isDD = marshalBitMask.isSet(3);
        if (this.marshaled) {
            int n = marshalReader.readInt();
            this.marshaledDestination = new byte[n];
            marshalReader.read(this.marshaledDestination, 0, n);
            this.unmarshalDestination();
        }
        if (marshalBitMask.isSet(2)) {
            this.createDestinationArgument = marshalReader.readString();
        }
    }

    public String toString() {
        return "ProxyDestination<+ " + this.name + ">";
    }
}

