/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.PrimitiveMap;
import weblogic.jms.dotnet.proxy.protocol.ProxyMessageImpl;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyMapMessageImpl
extends ProxyMessageImpl {
    private static final int EXTVERSION = 1;
    private static final int _HAS_DATA = 1;
    private PrimitiveMap map;
    private transient String contentStr;

    public ProxyMapMessageImpl() {
    }

    public ProxyMapMessageImpl(PrimitiveMap primitiveMap) {
        this.map = primitiveMap;
    }

    public ProxyMapMessageImpl(MapMessage mapMessage) throws JMSException {
        super((Message)mapMessage);
        this.copyMap(mapMessage);
    }

    private void copyMap(MapMessage mapMessage) throws JMSException {
        Enumeration enumeration = mapMessage.getMapNames();
        if (enumeration.hasMoreElements()) {
            this.map = new PrimitiveMap();
            do {
                String string = (String)enumeration.nextElement();
                this.map.put(string, mapMessage.getObject(string));
            } while (enumeration.hasMoreElements());
        }
    }

    public byte getType() {
        return 3;
    }

    public boolean itemExists(String string) throws JMSException {
        return this.map.containsKey(string);
    }

    public String toString() {
        if (this.contentStr == null) {
            this.contentStr = "";
            for (String string : this.map.keySet()) {
                Object object = this.map.get(string);
                this.contentStr = this.contentStr + "(" + string + "," + object + ")";
            }
        }
        return "MapMessage[" + this.getMessageID() + this.contentStr + "]";
    }

    public void populateJMSMessage(MapMessage mapMessage) throws JMSException {
        super.populateJMSMessage((Message)mapMessage);
        if (this.map != null) {
            for (String string : this.map.keySet()) {
                Object object = this.map.get(string);
                mapMessage.setObject(string, object);
            }
        }
    }

    public int getMarshalTypeCode() {
        return 37;
    }

    public void marshal(MarshalWriter marshalWriter) {
        super.marshal(marshalWriter);
        MarshalBitMask marshalBitMask = new MarshalBitMask(1);
        if (this.map != null) {
            marshalBitMask.setBit(1);
        }
        marshalBitMask.marshal(marshalWriter);
        if (this.map != null) {
            this.map.marshal(marshalWriter);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        super.unmarshal(marshalReader);
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        if (marshalBitMask.isSet(1)) {
            this.map = new PrimitiveMap();
            this.map.unmarshal(marshalReader);
        }
    }
}

