/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.PrimitiveMap;
import weblogic.jms.dotnet.proxy.protocol.ProxyBytesMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyDestinationImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyHdrMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyMapMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyObjectMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyStreamMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyTextMessageImpl;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.extensions.WLMessage;

public abstract class ProxyMessageImpl
implements MarshalReadable,
MarshalWritable {
    private static final int EXTVERSION = 1;
    public static final byte NULLMESSAGEIMPL = 0;
    public static final byte BYTESMESSAGEIMPL = 1;
    public static final byte HDRMESSAGEIMPL = 2;
    public static final byte MAPMESSAGEIMPL = 3;
    public static final byte OBJECTMESSAGEIMPL = 4;
    public static final byte STREAMMESSAGEIMPL = 5;
    public static final byte TEXTMESSAGEIMPL = 6;
    static final String[] headerFields = new String[]{"JMSCorrelationID", "JMSDeliveryMode", "JMSDestination", "JMSExpiration", "JMSPriority", "JMSRedelivered", "JMSReplyTo", "JMSTimestamp", "JMSType"};
    private int deliveryMode = -1;
    private int deliveryCount = 1;
    private int redeliveryLimit = -1;
    private int seed;
    private long timestamp = -1L;
    private int counter;
    private long expiration;
    private byte priority = (byte)-1;
    private String messageIdString;
    private JMSMessageId messageId;
    private String correlationId;
    private ProxyDestinationImpl destination;
    private ProxyDestinationImpl replyTo;
    private String type;
    private PrimitiveMap properties = new PrimitiveMap();
    private boolean redelivered;
    private long sequenceNumber = -1L;
    private int pipelineGeneration = 0;
    private transient Message message;
    private static final int _IS_PERSISTENT = 1;
    private static final int _HAS_CORRID = 2;
    private static final int _HAS_DESTINATION = 3;
    private static final int _HAS_REPLYTO = 4;
    private static final int _IS_REDELIVERED = 5;
    private static final int _HAS_TYPE = 6;
    private static final int _HAS_EXPIRATION = 7;
    private static final int _HAS_STRMESSAGEID = 8;
    private static final int _HAS_PROPERTIES = 9;
    private static final int _HAS_TIMESTAMP = 10;
    private static final int _HAS_SEQUENCE_NUMBER = 11;
    private static final int _HAS_PIPELINE_GENERATION = 12;
    private static final int _HAS_DELIVERY_COUNT = 13;
    private static final int _HAS_REDELIVERY_LIMIT = 14;
    private static final int _HAS_WLMESSAGEID = 15;

    public ProxyMessageImpl() {
    }

    public abstract byte getType();

    public static ProxyMessageImpl createMessageImpl(byte by) {
        switch (by) {
            case 1: {
                return new ProxyBytesMessageImpl();
            }
            case 2: {
                return new ProxyHdrMessageImpl();
            }
            case 3: {
                return new ProxyMapMessageImpl();
            }
            case 4: {
                return new ProxyObjectMessageImpl();
            }
            case 5: {
                return new ProxyStreamMessageImpl();
            }
            case 6: {
                return new ProxyTextMessageImpl();
            }
        }
        return null;
    }

    public ProxyMessageImpl(Message message) throws JMSException {
        this();
        this.initializeFromMessage(message);
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public void setPipelineGeneration(int n) {
        this.pipelineGeneration = n;
    }

    public final void setRedelivered(boolean bl) {
        this.redelivered = bl;
    }

    public void setDeliveryCount(int n) {
        this.deliveryCount = n;
    }

    private void initializeFromMessage(Message message) throws JMSException {
        this.message = message;
        this.timestamp = message.getJMSTimestamp();
        this.type = message.getJMSType();
        this.correlationId = message.getJMSCorrelationID();
        this.replyTo = message.getJMSReplyTo() != null ? new ProxyDestinationImpl(message.getJMSReplyTo()) : null;
        this.redelivered = message.getJMSRedelivered();
        this.expiration = message.getJMSExpiration();
        this.priority = (byte)message.getJMSPriority();
        this.deliveryMode = message.getJMSDeliveryMode();
        Enumeration enumeration = message.getPropertyNames();
        if (enumeration.hasMoreElements()) {
            this.properties = new PrimitiveMap();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("JMSXDeliveryCount") || string.equals("JMS_BEA_RedeliveryLimit")) continue;
                Object object = message.getObjectProperty(string);
                this.setObjectProperty(string, object);
            }
        }
        if (message instanceof WLMessage) {
            if (((MessageImpl)message).isOldMessage()) {
                this.messageIdString = message.getJMSMessageID();
            } else {
                this.messageId = ((MessageImpl)message).getId();
                this.seed = this.messageId.getSeed();
                this.counter = this.messageId.getCounter();
            }
            this.sequenceNumber = ((WLMessage)message).getSequenceNumber();
            if (((WLMessage)message).getUnitOfOrder() != null) {
                this.properties.put("JMS_BEA_UnitOfOrder", (Object)((WLMessage)message).getUnitOfOrder());
            }
            this.deliveryCount = ((MessageImpl)message).getDeliveryCount();
            this.redeliveryLimit = ((WLMessage)message).getJMSRedeliveryLimit();
        } else {
            this.messageIdString = message.getJMSMessageID();
        }
    }

    public final String getCorrelationID() {
        return this.correlationId;
    }

    public final String getMessageID() {
        if (this.messageIdString != null) {
            return this.messageIdString;
        }
        if (this.messageId != null) {
            return "ID:" + this.messageId.toString();
        }
        return "null";
    }

    public final int getDeliveryMode() {
        return this.deliveryMode;
    }

    public final ProxyDestinationImpl getDestination() {
        return this.destination;
    }

    public final long getExpiration() {
        return this.expiration;
    }

    public final long getDeliveryTime() {
        return (Long)this.properties.get("JMS_BEA_DeliveryTime");
    }

    public final int getPriority() {
        return this.priority;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public final void clearProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public final boolean propertyExists(String string) {
        return this.properties.get(string) != null;
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public final void setObjectProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void populateJMSMessage(Message message) throws JMSException {
        if (this.correlationId != null) {
            message.setJMSCorrelationID(this.correlationId);
        }
        message.setJMSType(this.type);
        if (this.replyTo != null) {
            message.setJMSReplyTo(this.replyTo.getJMSDestination());
        }
        if (this.redelivered) {
            message.setJMSRedelivered(true);
        }
        if (this.properties != null) {
            for (String string : this.properties.keySet()) {
                Object object = this.properties.get(string);
                message.setObjectProperty(string, object);
            }
        }
    }

    public void marshal(MarshalWriter marshalWriter) {
        boolean bl;
        MarshalBitMask marshalBitMask = new MarshalBitMask(1);
        if (this.messageIdString != null) {
            marshalBitMask.setBit(8);
        }
        if (this.messageId != null) {
            marshalBitMask.setBit(15);
        }
        if (this.timestamp != -1L) {
            marshalBitMask.setBit(10);
        }
        if (this.deliveryMode == 2) {
            marshalBitMask.setBit(1);
        }
        if (this.correlationId != null) {
            marshalBitMask.setBit(2);
        }
        if (this.destination != null) {
            marshalBitMask.setBit(3);
        }
        if (this.replyTo != null) {
            marshalBitMask.setBit(4);
        }
        if (this.redelivered) {
            marshalBitMask.setBit(5);
        }
        if (this.type != null) {
            marshalBitMask.setBit(6);
        }
        if (this.deliveryCount != 1) {
            marshalBitMask.setBit(13);
        }
        if (this.redeliveryLimit != -1) {
            marshalBitMask.setBit(14);
        }
        if (this.expiration != 0L) {
            marshalBitMask.setBit(7);
        }
        if (bl = this.hasProperties()) {
            marshalBitMask.setBit(9);
        }
        if (this.sequenceNumber != -1L) {
            marshalBitMask.setBit(11);
        }
        if (this.pipelineGeneration != 0) {
            marshalBitMask.setBit(12);
        }
        marshalBitMask.marshal(marshalWriter);
        if (this.messageIdString != null) {
            marshalWriter.writeString(this.messageIdString);
        }
        if (this.messageId != null) {
            marshalWriter.writeInt(this.seed);
            marshalWriter.writeInt(this.counter);
        }
        if (this.timestamp != -1L) {
            marshalWriter.writeLong(this.timestamp);
        }
        if (this.correlationId != null) {
            marshalWriter.writeString(this.correlationId);
        }
        if (this.destination != null) {
            this.destination.marshal(marshalWriter);
        }
        if (this.replyTo != null) {
            this.replyTo.marshal(marshalWriter);
        }
        if (this.type != null) {
            marshalWriter.writeString(this.type);
        }
        if (this.expiration != 0L) {
            marshalWriter.writeLong(this.expiration);
        }
        if (this.deliveryCount != 1) {
            marshalWriter.writeInt(this.deliveryCount);
        }
        if (this.redeliveryLimit != -1) {
            marshalWriter.writeInt(this.redeliveryLimit);
        }
        marshalWriter.writeByte(this.priority);
        if (bl) {
            this.properties.marshal(marshalWriter);
        }
        if (this.sequenceNumber != -1L) {
            marshalWriter.writeLong(this.sequenceNumber);
        }
        if (this.pipelineGeneration != 0) {
            marshalWriter.writeInt(this.pipelineGeneration);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        this.deliveryMode = marshalBitMask.isSet(1) ? 2 : 1;
        if (marshalBitMask.isSet(8)) {
            this.messageIdString = marshalReader.readString();
        }
        if (marshalBitMask.isSet(15)) {
            this.seed = marshalReader.readInt();
            this.counter = marshalReader.readInt();
            this.messageIdString = "ID:<" + this.seed + "." + this.timestamp + "." + this.counter + ">";
        }
        if (marshalBitMask.isSet(10)) {
            this.timestamp = marshalReader.readLong();
        }
        if (marshalBitMask.isSet(2)) {
            this.correlationId = marshalReader.readString();
        }
        if (marshalBitMask.isSet(3)) {
            this.destination = new ProxyDestinationImpl();
            this.destination.unmarshal(marshalReader);
        }
        if (marshalBitMask.isSet(4)) {
            this.replyTo = new ProxyDestinationImpl();
            this.replyTo.unmarshal(marshalReader);
        }
        this.redelivered = marshalBitMask.isSet(5);
        if (marshalBitMask.isSet(6)) {
            this.type = marshalReader.readString();
        }
        if (marshalBitMask.isSet(7)) {
            this.expiration = marshalReader.readLong();
        }
        if (marshalBitMask.isSet(13)) {
            this.deliveryCount = marshalReader.readInt();
        }
        if (marshalBitMask.isSet(14)) {
            this.redeliveryLimit = marshalReader.readInt();
        }
        this.priority = marshalReader.readByte();
        if (marshalBitMask.isSet(9)) {
            this.properties = new PrimitiveMap();
            this.properties.unmarshal(marshalReader);
        }
        if (marshalBitMask.isSet(11)) {
            this.sequenceNumber = marshalReader.readLong();
        }
        if (marshalBitMask.isSet(12)) {
            this.pipelineGeneration = marshalReader.readInt();
        }
    }

    public static boolean isHeaderField(String string) {
        if (string.startsWith("JMS")) {
            for (int i = 0; i < headerFields.length; ++i) {
                if (!string.equals(headerFields[i])) continue;
                return true;
            }
        }
        return false;
    }
}

