/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import javax.jms.JMSException;
import javax.jms.MessageProducer;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyResponse;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.extensions.WLMessageProducer;

public class ProxyProducerCreateResponse
extends ProxyResponse {
    private static final int EXTVERSION = 1;
    private static final int _HAS_EXTENSIONS = 1;
    private static final int _HAS_DEFAULT_UOO = 2;
    private static final int _HAS_COMPRESSION_THRESHOLD = 3;
    private long id;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    private long timeToDeliver;
    private long sendTimeOut;
    private String unitOfOrder;
    private long compressionThreshold;
    private boolean hasExtensions;

    public ProxyProducerCreateResponse(long l, MessageProducer messageProducer) throws JMSException {
        this.id = l;
        this.deliveryMode = messageProducer.getDeliveryMode();
        this.priority = messageProducer.getPriority();
        this.timeToLive = messageProducer.getTimeToLive();
        if (messageProducer instanceof WLMessageProducer) {
            this.hasExtensions = true;
            this.timeToDeliver = ((WLMessageProducer)messageProducer).getTimeToDeliver();
            this.sendTimeOut = ((WLMessageProducer)messageProducer).getSendTimeout();
            this.unitOfOrder = ((WLMessageProducer)messageProducer).getUnitOfOrder();
            this.compressionThreshold = ((WLMessageProducer)messageProducer).getCompressionThreshold();
        }
    }

    public long getProducerId() {
        return this.id;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public long getTimeToDeliver() {
        return this.timeToDeliver;
    }

    public long getSendTimeOut() {
        return this.sendTimeOut;
    }

    public String getUnitOfOrder() {
        return this.unitOfOrder;
    }

    public long getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public ProxyProducerCreateResponse() {
    }

    public int getMarshalTypeCode() {
        return 24;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.hasExtensions) {
            this.versionFlags.setBit(1);
        }
        if (this.unitOfOrder != null) {
            this.versionFlags.setBit(2);
        }
        if (this.compressionThreshold != Integer.MAX_VALUE) {
            this.versionFlags.setBit(3);
        }
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeLong(this.id);
        marshalWriter.writeInt(this.deliveryMode);
        marshalWriter.writeInt(this.priority);
        marshalWriter.writeLong(this.timeToLive);
        if (this.hasExtensions) {
            marshalWriter.writeLong(this.timeToDeliver);
            marshalWriter.writeLong(this.sendTimeOut);
            if (this.unitOfOrder != null) {
                marshalWriter.writeString(this.unitOfOrder);
            }
            if (this.compressionThreshold != Integer.MAX_VALUE) {
                marshalWriter.writeLong(this.compressionThreshold);
            }
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        this.id = marshalReader.readLong();
        this.deliveryMode = marshalReader.readInt();
        this.priority = marshalReader.readInt();
        this.timeToLive = marshalReader.readLong();
        if (this.versionFlags.isSet(1)) {
            this.timeToDeliver = marshalReader.readLong();
            this.sendTimeOut = marshalReader.readLong();
            if (this.versionFlags.isSet(2)) {
                this.unitOfOrder = marshalReader.readString();
            }
            if (this.versionFlags.isSet(3)) {
                this.compressionThreshold = marshalReader.readLong();
            }
        }
    }
}

