/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyResponse;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyProducerSendResponse
extends ProxyResponse {
    private static final int EXTVERSION = 1;
    private static final int _HAS_DELIVERY_MODE = 1;
    private static final int _HAS_PRIORITY = 2;
    private static final int _HAS_TIME_STAMP = 3;
    private static final int _HAS_EXPIRATION = 4;
    private static final int _HAS_TIME_TO_DELIVER = 5;
    private static final int _HAS_FLOW_CONTROL = 6;
    private static final int _HAS_REDELIVERY_LIMIT = 7;
    private static final int _HAS_WLMESSAGEID = 8;
    private String messageId;
    private int deliveryMode = -1;
    private int priority;
    private int seed;
    private long timestamp;
    private int counter;
    private long expirationTime;
    private long deliveryTime;
    private int redeliveryLimit;
    private long flowControlTime;

    public ProxyProducerSendResponse(String string) {
        this.messageId = string;
        this.versionFlags = new MarshalBitMask(1);
    }

    public ProxyProducerSendResponse(int n, int n2) {
        this.seed = n;
        this.counter = n2;
        this.versionFlags = new MarshalBitMask(1);
        this.versionFlags.setBit(8);
    }

    public String getMessageId() {
        if (this.messageId != null) {
            return this.messageId;
        }
        return "ID:<" + this.seed + "." + this.timestamp + "." + this.counter + ">";
    }

    public void setDeliveryMode(int n) {
        this.versionFlags.setBit(1);
        this.deliveryMode = n;
    }

    public int getDeliveryMode() {
        if (!this.versionFlags.isSet(1)) {
            return -1;
        }
        return this.deliveryMode;
    }

    public void setPriority(int n) {
        this.versionFlags.setBit(2);
        this.priority = n;
    }

    public int getPriority() {
        if (!this.versionFlags.isSet(2)) {
            return -1;
        }
        return this.priority;
    }

    public void setExpirationTime(long l) {
        this.versionFlags.setBit(4);
        this.expirationTime = l;
    }

    public long getExpirationTime() {
        if (!this.versionFlags.isSet(4)) {
            return -1L;
        }
        return this.expirationTime;
    }

    public void setTimestamp(long l) {
        this.versionFlags.setBit(3);
        this.timestamp = l;
    }

    public long getTimestamp() {
        if (!this.versionFlags.isSet(3)) {
            return -1L;
        }
        return this.timestamp;
    }

    public void setDeliveryTime(long l) {
        this.versionFlags.setBit(5);
        this.deliveryTime = l;
    }

    public long getTimeToDeliver() {
        if (!this.versionFlags.isSet(5)) {
            return -1L;
        }
        return this.deliveryTime;
    }

    public void setRedeliveryLimit(int n) {
        this.versionFlags.setBit(7);
        this.redeliveryLimit = n;
    }

    public int getRedeliveryLimit() {
        if (!this.versionFlags.isSet(7)) {
            return 0;
        }
        return this.redeliveryLimit;
    }

    public void setFlowControlTime(long l) {
        if (l != 0L) {
            this.versionFlags.setBit(6);
        }
        this.flowControlTime = l;
    }

    public long getFlowControlTime() {
        if (!this.versionFlags.isSet(6)) {
            return 0L;
        }
        return this.flowControlTime;
    }

    public ProxyProducerSendResponse() {
    }

    public int getMarshalTypeCode() {
        return 26;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags.marshal(marshalWriter);
        if (this.versionFlags.isSet(8)) {
            marshalWriter.writeInt(this.seed);
            marshalWriter.writeInt(this.counter);
        } else {
            marshalWriter.writeString(this.messageId);
        }
        if (this.versionFlags.isSet(1)) {
            marshalWriter.writeInt(this.deliveryMode);
        }
        if (this.versionFlags.isSet(2)) {
            marshalWriter.writeInt(this.priority);
        }
        if (this.versionFlags.isSet(4)) {
            marshalWriter.writeLong(this.expirationTime);
        }
        if (this.versionFlags.isSet(3)) {
            marshalWriter.writeLong(this.timestamp);
        }
        if (this.versionFlags.isSet(5)) {
            marshalWriter.writeLong(this.deliveryTime);
        }
        if (this.versionFlags.isSet(7)) {
            marshalWriter.writeInt(this.redeliveryLimit);
        }
        if (this.versionFlags.isSet(6)) {
            marshalWriter.writeLong(this.flowControlTime);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        if (marshalBitMask.isSet(8)) {
            this.seed = marshalReader.readInt();
            this.counter = marshalReader.readInt();
        } else {
            this.messageId = marshalReader.readString();
        }
        if (marshalBitMask.isSet(1)) {
            this.deliveryMode = marshalReader.readInt();
        }
        if (marshalBitMask.isSet(2)) {
            this.priority = marshalReader.readInt();
        }
        if (marshalBitMask.isSet(4)) {
            this.expirationTime = marshalReader.readLong();
        }
        if (marshalBitMask.isSet(3)) {
            this.timestamp = marshalReader.readLong();
        }
        if (marshalBitMask.isSet(5)) {
            this.deliveryTime = marshalReader.readLong();
        }
        if (marshalBitMask.isSet(7)) {
            this.redeliveryLimit = marshalReader.readInt();
        }
        if (marshalBitMask.isSet(6)) {
            this.flowControlTime = marshalReader.readLong();
        }
    }
}

