/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyPushMessageRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyResponse;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyPushMessageListRequest
extends ProxyResponse {
    private static final int EXTVERSION = 1;
    private ProxyPushMessageRequest first;
    private ProxyPushMessageRequest last;
    private int pipelineSize;
    private int size;

    public ProxyPushMessageListRequest() {
    }

    public ProxyPushMessageListRequest(int n) {
        this.pipelineSize = n;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void add(ProxyPushMessageRequest proxyPushMessageRequest) {
        ++this.size;
        proxyPushMessageRequest.setNext(null);
        if (this.first == null) {
            this.first = proxyPushMessageRequest;
            this.last = proxyPushMessageRequest;
            return;
        }
        this.last.setNext(proxyPushMessageRequest);
        this.last = proxyPushMessageRequest;
    }

    public int getMarshalTypeCode() {
        return 51;
    }

    public synchronized void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeInt(this.pipelineSize);
        marshalWriter.writeInt(this.size);
        for (ProxyPushMessageRequest proxyPushMessageRequest = this.first; proxyPushMessageRequest != null; proxyPushMessageRequest = proxyPushMessageRequest.getNext()) {
            proxyPushMessageRequest.marshal(marshalWriter);
        }
    }

    public synchronized void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        this.pipelineSize = marshalReader.readInt();
        int n = marshalReader.readInt();
        while (n-- > 0) {
            ProxyPushMessageRequest proxyPushMessageRequest = new ProxyPushMessageRequest();
            proxyPushMessageRequest.unmarshal(marshalReader);
            this.add(proxyPushMessageRequest);
        }
    }
}

