/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyResponse;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyPushMessageRequest
extends ProxyResponse {
    private static final int EXTVERSION = 1;
    private static final int _SUGGEST_WINDOW_TURN = 1;
    private long consumerId;
    private ProxyMessageImpl message;
    private boolean suggestWindowTurn;
    private ProxyPushMessageRequest next;

    public ProxyPushMessageRequest(long l, ProxyMessageImpl proxyMessageImpl, boolean bl) {
        this.consumerId = l;
        this.message = proxyMessageImpl;
        this.suggestWindowTurn = bl;
    }

    void setNext(ProxyPushMessageRequest proxyPushMessageRequest) {
        this.next = proxyPushMessageRequest;
    }

    ProxyPushMessageRequest getNext() {
        return this.next;
    }

    public ProxyMessageImpl getMessage() {
        return this.message;
    }

    public ProxyPushMessageRequest() {
    }

    public int getMarshalTypeCode() {
        return 44;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.suggestWindowTurn) {
            this.versionFlags.setBit(1);
        }
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeLong(this.consumerId);
        marshalWriter.writeByte(this.message.getType());
        this.message.marshal(marshalWriter);
    }

    public void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        this.consumerId = marshalReader.readLong();
        byte by = marshalReader.readByte();
        this.message = ProxyMessageImpl.createMessageImpl(by);
        this.message.unmarshal(marshalReader);
        this.suggestWindowTurn = this.versionFlags.isSet(1);
    }
}

