/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyRequest;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxySessionCreateRequest
extends ProxyRequest {
    private static final int EXTVERSION = 1;
    private static final int _IS_TRANSACTED = 1;
    private static final int _IS_XA_SESSION = 2;
    private boolean transacted;
    private boolean xaSession;
    private int acknowledgeMode;
    private long sessionMsgListenerServiceId;

    public ProxySessionCreateRequest(boolean bl, boolean bl2, int n, long l) {
        this.transacted = bl;
        this.xaSession = bl2;
        this.acknowledgeMode = n;
        this.sessionMsgListenerServiceId = l;
    }

    public final long getSessionMsgListenerServiceId() {
        return this.sessionMsgListenerServiceId;
    }

    public final boolean getTransacted() {
        return this.transacted;
    }

    public final boolean getXASession() {
        return this.xaSession;
    }

    public final int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public ProxySessionCreateRequest() {
    }

    public int getMarshalTypeCode() {
        return 30;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.transacted) {
            this.versionFlags.setBit(1);
        }
        if (this.xaSession) {
            this.versionFlags.setBit(2);
        }
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeInt(this.acknowledgeMode);
        marshalWriter.writeLong(this.sessionMsgListenerServiceId);
    }

    public void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        if (this.versionFlags.isSet(1)) {
            this.transacted = true;
        }
        if (this.versionFlags.isSet(2)) {
            this.xaSession = true;
        }
        this.acknowledgeMode = marshalReader.readInt();
        this.sessionMsgListenerServiceId = marshalReader.readLong();
    }
}

