/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import javax.jms.JMSException;
import javax.jms.Session;
import weblogic.jms.client.WLSessionImpl;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyResponse;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.extensions.WLSession;

public class ProxySessionCreateResponse
extends ProxyResponse {
    private static final int EXTVERSION = 1;
    private static final int _HAS_EXTENSIONS = 1;
    private long sessionId;
    private int messagesMaximum;
    private long redeliveryDelay;
    private int pipelineGeneration;
    private long sequenceNumber;
    private boolean hasExtensions;

    public ProxySessionCreateResponse(long l, Session session) {
        this.sessionId = l;
        if (session instanceof WLSession) {
            try {
                this.hasExtensions = true;
                this.messagesMaximum = ((WLSession)session).getMessagesMaximum();
                this.redeliveryDelay = ((WLSession)session).getRedeliveryDelay();
                this.pipelineGeneration = ((WLSessionImpl)session).getPipelineGenerationFromProxy();
                this.sequenceNumber = ((WLSessionImpl)session).getLastSequenceNumber();
            }
            catch (JMSException jMSException) {
                throw new RuntimeException(jMSException);
            }
        }
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public ProxySessionCreateResponse() {
    }

    public int getMarshalTypeCode() {
        return 31;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.hasExtensions) {
            this.versionFlags.setBit(1);
        }
        this.versionFlags.marshal(marshalWriter);
        marshalWriter.writeLong(this.sessionId);
        if (this.hasExtensions) {
            marshalWriter.writeInt(this.messagesMaximum);
            marshalWriter.writeLong(this.redeliveryDelay);
            marshalWriter.writeInt(this.pipelineGeneration);
            marshalWriter.writeLong(this.sequenceNumber);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        this.versionFlags = new MarshalBitMask();
        this.versionFlags.unmarshal(marshalReader);
        ProxyUtil.checkVersion(this.versionFlags.getVersion(), 1, 1);
        this.sessionId = marshalReader.readLong();
        if (this.versionFlags.isSet(1)) {
            this.messagesMaximum = marshalReader.readInt();
            this.redeliveryDelay = marshalReader.readLong();
            this.pipelineGeneration = marshalReader.readInt();
            this.sequenceNumber = marshalReader.readLong();
        }
    }
}

