/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyRequest;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxySessionRecoverRequest
extends ProxyRequest {
    private static final int EXTVERSION = 1;
    private static final int _IS_DO_ROLLBACK = 1;
    private static final int _HAS_SEQUENCENUMBER = 2;
    private boolean doRollback;
    private long sequenceNumber;

    public ProxySessionRecoverRequest(long l, boolean bl) {
        this.sequenceNumber = l;
        this.doRollback = bl;
    }

    public final boolean isDoRollback() {
        return this.doRollback;
    }

    public final long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public ProxySessionRecoverRequest() {
    }

    public int getMarshalTypeCode() {
        return 32;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.doRollback) {
            this.versionFlags.setBit(1);
        }
        if (this.sequenceNumber != 0L) {
            this.versionFlags.setBit(2);
        }
        this.versionFlags.marshal(marshalWriter);
        if (this.sequenceNumber != 0L) {
            marshalWriter.writeLong(this.sequenceNumber);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        this.doRollback = marshalBitMask.isSet(1);
        if (marshalBitMask.isSet(2)) {
            this.sequenceNumber = marshalReader.readLong();
        }
    }
}

