/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyResponse;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxySessionRecoverResponse
extends ProxyResponse {
    private static final int EXTVERSION = 1;
    private static final int _HAS_GENERATION = 1;
    private int generation = 0;

    public ProxySessionRecoverResponse(int n) {
        this.generation = n;
    }

    public final long getGeneration() {
        return this.generation;
    }

    public ProxySessionRecoverResponse() {
    }

    public int getMarshalTypeCode() {
        return 33;
    }

    public void marshal(MarshalWriter marshalWriter) {
        this.versionFlags = new MarshalBitMask(1);
        if (this.generation != 0) {
            this.versionFlags.setBit(1);
        }
        this.versionFlags.marshal(marshalWriter);
        if (this.generation != 0) {
            marshalWriter.writeInt(this.generation);
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        if (marshalBitMask.isSet(1)) {
            this.generation = marshalReader.readInt();
        }
    }
}

