/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.StreamMessage;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyMessageImpl;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyStreamMessageImpl
extends ProxyMessageImpl {
    private static final int EXTVERSION = 1;
    private static final int _HAS_DATA = 1;
    private PayloadStream payload;

    public ProxyStreamMessageImpl() {
    }

    public ProxyStreamMessageImpl(StreamMessage streamMessage) throws JMSException {
        super((Message)streamMessage);
        this.payload = ((StreamMessageImpl)streamMessage).getPayload();
    }

    public byte getType() {
        return 5;
    }

    public void populateJMSMessage(StreamMessage streamMessage) throws JMSException {
        super.populateJMSMessage((Message)streamMessage);
        ((StreamMessageImpl)streamMessage).setPayload(this.payload);
    }

    public String toString() {
        return "StreamMessage[" + this.getMessageID() + " payload = " + this.payload + "]";
    }

    public int getMarshalTypeCode() {
        return 38;
    }

    public void marshal(MarshalWriter marshalWriter) {
        super.marshal(marshalWriter);
        MarshalBitMask marshalBitMask = new MarshalBitMask(1);
        if (this.payload != null && this.payload.getLength() != 0) {
            marshalBitMask.setBit(1);
        }
        marshalBitMask.marshal(marshalWriter);
        if (marshalBitMask.isSet(1)) {
            try {
                this.payload.writeLengthAndData(marshalWriter.getDataOutputStream());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        super.unmarshal(marshalReader);
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        if (marshalBitMask.isSet(1)) {
            try {
                DataInput dataInput = marshalReader.getDataInputStream();
                this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)dataInput));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

