/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.protocol;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadText;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.MarshalBitMask;
import weblogic.jms.dotnet.proxy.protocol.ProxyMessageImpl;
import weblogic.jms.dotnet.proxy.util.ProxyUtil;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class ProxyTextMessageImpl
extends ProxyMessageImpl {
    private static final int EXTVERSION = 1;
    private static final int _HAS_STRING_DATA = 1;
    private String text;
    private PayloadText payload;
    private static final boolean mydebug = false;

    public ProxyTextMessageImpl() {
    }

    public ProxyTextMessageImpl(TextMessage textMessage) throws JMSException {
        super((Message)textMessage);
        Object object = ((TextMessageImpl)textMessage).getMessageBody();
        if (object instanceof PayloadText) {
            this.payload = (PayloadText)object;
        } else {
            this.text = (String)object;
            if (this.text == null) {
                this.text = textMessage.getText();
            }
        }
    }

    public byte getType() {
        return 6;
    }

    public ProxyTextMessageImpl(String string) {
        this.text = string;
    }

    public void setText(String string) throws JMSException {
        this.text = string;
    }

    public String getText() throws JMSException {
        if (this.text != null) {
            return this.text;
        }
        if (this.payload != null) {
            try {
                this.text = this.payload.readUTF8();
                this.payload = null;
                return this.text;
            }
            catch (IOException iOException) {
                throw new weblogic.jms.common.JMSException(iOException);
            }
        }
        return this.text;
    }

    public String toString() {
        return "TextMessage[" + this.getMessageID() + ", " + (this.text == null ? "null" : (this.text.length() < 40 ? this.text : this.text.substring(0, 30) + "...")) + "]";
    }

    public void populateJMSMessage(TextMessage textMessage) throws JMSException {
        super.populateJMSMessage((Message)textMessage);
        if (this.payload != null) {
            ((TextMessageImpl)textMessage).setUTF8Buffer(this.payload);
        }
    }

    public int getMarshalTypeCode() {
        return 35;
    }

    public void marshal(MarshalWriter marshalWriter) {
        super.marshal(marshalWriter);
        MarshalBitMask marshalBitMask = new MarshalBitMask(1);
        if (this.text != null || this.payload != null) {
            marshalBitMask.setBit(1);
        }
        marshalBitMask.marshal(marshalWriter);
        if (this.text != null) {
            marshalWriter.writeString(this.text);
        } else if (this.payload != null) {
            try {
                this.payload.writeLengthAndData(marshalWriter.getDataOutputStream());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        super.unmarshal(marshalReader);
        MarshalBitMask marshalBitMask = new MarshalBitMask();
        marshalBitMask.unmarshal(marshalReader);
        ProxyUtil.checkVersion(marshalBitMask.getVersion(), 1, 1);
        if (marshalBitMask.isSet(1)) {
            try {
                DataInput dataInput = marshalReader.getDataInputStream();
                this.payload = (PayloadText)PayloadFactoryImpl.createPayload((InputStream)((Object)dataInput));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

