/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.t3.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.rmi.RemoteException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dotnet.t3.server.internal.T3ConnectionHandleID;
import weblogic.jms.dotnet.t3.server.internal.T3ConnectionImpl;
import weblogic.jms.dotnet.t3.server.internal.T3RJVM;
import weblogic.jms.dotnet.t3.server.spi.T3ConnectionHandle;
import weblogic.jms.dotnet.t3.server.spi.T3ConnectionHandleFactory;
import weblogic.jms.dotnet.t3.server.spi.impl.T3ConnectionHandleFactoryImpl;
import weblogic.protocol.ServerChannel;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.RemoteInvokable;
import weblogic.rjvm.RemoteRequest;
import weblogic.rjvm.ReplyStream;
import weblogic.rmi.spi.InboundRequest;
import weblogic.utils.collections.NumericKeyHashMap;
import weblogic.utils.io.ChunkedDataInputStream;

public final class JMSCSharp
implements RemoteInvokable {
    public static final byte REMOTE_INVOKE_HELLO_REQUEST = 1;
    public static final byte REMOTE_INVOKE_HELLO_RESPONSE = 2;
    public static final byte REMOTE_INVOKE_DISPATCH_REQUEST = 3;
    public static final byte REMOTE_INVOKE_FAILURE = 4;
    private static final byte REMOTE_INVOKE_FAILURE_UNKNOWN_OPCODE = 1;
    private static final byte REMOTE_INVOKE_FAILURE_DUPLICATE_RJVM = 2;
    private static final byte REMOTE_INVOKE_FAILURE_UNKNOWN_HANDLEID = 3;
    private static final int DEFAULT_SERVICE_ID = 0;
    private static JMSCSharp me = new JMSCSharp();
    private static T3ConnectionHandleFactory[] hFactories = new T3ConnectionHandleFactory[128];
    private final NumericKeyHashMap handles = new NumericKeyHashMap();
    private long handleID = 0L;

    private JMSCSharp() {
    }

    public static JMSCSharp getInstance() {
        return me;
    }

    public static synchronized void setT3ConnectionHandleFactory(int n, T3ConnectionHandleFactory t3ConnectionHandleFactory) {
        if (n > 128 || n < 0) {
            throw new IllegalArgumentException("Service id must be in the range of 0 to 128");
        }
        if (hFactories[n] != null) {
            throw new IllegalArgumentException("Service id is used");
        }
        if (JMSDebug.JMSDotNetT3Server.isDebugEnabled()) {
            JMSDebug.JMSDotNetT3Server.debug("T3 service " + n + " is registered with " + t3ConnectionHandleFactory);
        }
        JMSCSharp.hFactories[n] = t3ConnectionHandleFactory;
    }

    public void invoke(RemoteRequest remoteRequest) throws RemoteException {
        byte by;
        try {
            by = remoteRequest.readByte();
        }
        catch (IOException iOException) {
            throw new RemoteException("RemoteRequest: missing JMS .net client opcode");
        }
        switch (by) {
            case 1: {
                this.processHelloRequest(remoteRequest);
                break;
            }
            case 3: {
                this.dispatchRequest(remoteRequest);
                break;
            }
            default: {
                this.reportFailure((byte)1, by);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_connection(T3ConnectionHandleID t3ConnectionHandleID) {
        NumericKeyHashMap numericKeyHashMap = this.handles;
        synchronized (numericKeyHashMap) {
            this.handles.remove(t3ConnectionHandleID.getValue());
        }
    }

    private void reportFailure(byte by, byte by2) {
        switch (by) {
            case 1: {
                System.out.println("REMOTE_INVOKE_FAILURE_UNKNOWN_OPCODE  " + by2);
                break;
            }
            default: {
                System.out.println("FailCode  " + by + " cmd " + by2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndReportFailure(RemoteRequest remoteRequest, byte by) {
        try {
            ReplyStream replyStream = remoteRequest.getResponseStream();
            replyStream.writeByte(4);
            replyStream.writeByte((int)by);
            replyStream.send();
        }
        catch (IOException iOException) {
        }
        finally {
            this.reportFailure(by, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHelloRequest(RemoteRequest remoteRequest) throws RemoteException {
        byte by;
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        try {
            n4 = remoteRequest.readInt();
            n3 = remoteRequest.readInt();
            n2 = remoteRequest.readInt();
            n = remoteRequest.readInt();
            bl = remoteRequest.readBoolean();
            by = remoteRequest.readByte();
        }
        catch (IOException iOException) {
            throw new RemoteException("RemoteRequest: T3 connection [hello] syntax error");
        }
        if (by > 128 || by < 0) {
            throw new RemoteException("T3 service id should be in range of 0 to 128");
        }
        if (hFactories[by] == null) {
            throw new RemoteException("T3 service " + by + " is empty");
        }
        T3RJVM t3RJVM = this.getT3RJVM(remoteRequest);
        T3ConnectionHandleID t3ConnectionHandleID = this.getNextHandleID();
        T3ConnectionImpl t3ConnectionImpl = new T3ConnectionImpl(t3RJVM, t3ConnectionHandleID, n4, n3, n2, n, bl);
        t3RJVM.getRJVM().addPeerGoneListener((PeerGoneListener)t3ConnectionImpl);
        T3ConnectionHandle t3ConnectionHandle = hFactories[by].createHandle(t3ConnectionImpl);
        t3ConnectionImpl.setT3ConnectionGoneListener(t3ConnectionHandle);
        NumericKeyHashMap numericKeyHashMap = this.handles;
        synchronized (numericKeyHashMap) {
            if (!t3ConnectionImpl.isClosed()) {
                t3ConnectionHandleID.setHandle(t3ConnectionHandle);
                t3ConnectionHandleID.setConnection(t3ConnectionImpl);
                this.handles.put(t3ConnectionHandleID.getValue(), (Object)t3ConnectionHandleID);
            }
        }
        if (JMSDebug.JMSDotNetT3Server.isDebugEnabled()) {
            JMSDebug.JMSDotNetT3Server.debug("T3 service id [" + by + "] hello request From " + t3RJVM.getRJVM() + ", assigned connection id " + t3ConnectionHandleID.getValue());
        }
        try {
            numericKeyHashMap = remoteRequest.getResponseStream();
            numericKeyHashMap.write(2);
            numericKeyHashMap.writeLong(t3ConnectionHandleID.getValue());
            numericKeyHashMap.send();
        }
        catch (IOException iOException) {
            throw new RemoteException("RemoteRequest: Failed to send [hello] response", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchRequest(RemoteRequest remoteRequest) throws RemoteException {
        T3ConnectionHandle t3ConnectionHandle;
        long l;
        try {
            l = remoteRequest.readLong();
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.toString(), iOException);
        }
        NumericKeyHashMap numericKeyHashMap = this.handles;
        synchronized (numericKeyHashMap) {
            T3ConnectionHandleID t3ConnectionHandleID = (T3ConnectionHandleID)this.handles.get(l);
            if (t3ConnectionHandleID == null) {
                this.reportFailure((byte)3, (byte)0);
                return;
            }
            t3ConnectionHandle = t3ConnectionHandleID.getHandle();
        }
        t3ConnectionHandle.onMessage((ChunkedDataInputStream)remoteRequest);
    }

    private synchronized T3ConnectionHandleID getNextHandleID() {
        return new T3ConnectionHandleID(++this.handleID);
    }

    private T3RJVM getT3RJVM(RemoteRequest remoteRequest) throws RemoteException {
        JVMID jVMID = new JVMID();
        try {
            jVMID.readExternal((ObjectInput)remoteRequest);
        }
        catch (IOException iOException) {
            throw new RemoteException("RemoteRequest: T3 connection [hello] syntax error", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RemoteException("RemoteRequest: Unknown JVMID syntax " + classNotFoundException);
        }
        RJVM rJVM = RJVMManager.getRJVMManager().findOrCreate(jVMID);
        ServerChannel serverChannel = ((InboundRequest)remoteRequest).getServerChannel();
        return new T3RJVM(rJVM, serverChannel);
    }

    public int hashCode() {
        return 41;
    }

    static {
        JMSCSharp.setT3ConnectionHandleFactory(0, new T3ConnectionHandleFactoryImpl());
    }
}

