/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.t3.server.internal;

import java.io.IOException;
import java.rmi.RemoteException;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dotnet.t3.server.JMSCSharp;
import weblogic.jms.dotnet.t3.server.internal.T3ConnectionGoneEventImpl;
import weblogic.jms.dotnet.t3.server.internal.T3ConnectionHandleID;
import weblogic.jms.dotnet.t3.server.internal.T3RJVM;
import weblogic.jms.dotnet.t3.server.spi.T3Connection;
import weblogic.jms.dotnet.t3.server.spi.T3ConnectionGoneListener;
import weblogic.jms.dotnet.t3.server.spi.T3ConnectionHandle;
import weblogic.rjvm.JVMID;
import weblogic.rjvm.MsgAbbrevOutputStream;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.RequestStream;
import weblogic.utils.io.ChunkedDataOutputStream;

public final class T3ConnectionImpl
implements T3Connection,
PeerGoneListener {
    private T3RJVM t3rjvm;
    private T3ConnectionHandleID id;
    private boolean closed = false;
    private boolean closedByClient = false;
    private PeerInfo peerInfo;
    private T3ConnectionGoneListener listener;

    public T3ConnectionImpl(T3RJVM t3RJVM, T3ConnectionHandleID t3ConnectionHandleID, int n, int n2, int n3, int n4, boolean bl) throws RemoteException {
        this.t3rjvm = t3RJVM;
        this.id = t3ConnectionHandleID;
        this.peerInfo = new PeerInfo(n, n2, n3, n4, bl, null);
        String string = "" + this.peerInfo.getMajor() + "." + this.peerInfo.getMinor() + "." + this.peerInfo.getServicePack() + "." + this.peerInfo.getRollingPatch();
        if (!VersionInfo.theOne().compatible(string)) {
            throw new IllegalArgumentException("Remote version is not compatible");
        }
    }

    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    public ChunkedDataOutputStream getRequestStream() throws IOException {
        this.check_close();
        MsgAbbrevOutputStream msgAbbrevOutputStream = this.t3rjvm.getRJVM().getRequestStream(this.t3rjvm.getServerChannel());
        msgAbbrevOutputStream.writeByte(3);
        return (ChunkedDataOutputStream)msgAbbrevOutputStream;
    }

    public void send(ChunkedDataOutputStream chunkedDataOutputStream) throws IOException {
        this.check_close();
        RequestStream requestStream = (RequestStream)chunkedDataOutputStream;
        try {
            requestStream.sendOneWay(100);
        }
        catch (RemoteException remoteException) {
            IOException iOException = new IOException(remoteException.toString());
            iOException.initCause(remoteException.getCause());
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setT3ConnectionGoneListener(T3ConnectionGoneListener t3ConnectionGoneListener) {
        boolean bl = false;
        boolean bl2 = false;
        T3ConnectionImpl t3ConnectionImpl = this;
        synchronized (t3ConnectionImpl) {
            bl = this.closed;
            bl2 = this.closedByClient;
            this.listener = t3ConnectionGoneListener;
        }
        if (bl && !bl2) {
            ((T3ConnectionHandle)t3ConnectionGoneListener).onPeerGone(new T3ConnectionGoneEventImpl(new IOException("Remote RJMV is closed already")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerGone(PeerGoneEvent peerGoneEvent) {
        block11: {
            T3ConnectionGoneListener t3ConnectionGoneListener = null;
            T3ConnectionImpl t3ConnectionImpl = this;
            synchronized (t3ConnectionImpl) {
                block10: {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    if (JMSDebug.JMSDotNetT3Server.isDebugEnabled()) {
                        JMSDebug.JMSDotNetT3Server.debug("T3 connection [" + this.id.getValue() + "] is terminated");
                    }
                    try {
                        this.t3rjvm.getRJVM().disconnect();
                    }
                    catch (Throwable throwable) {
                        if (!JMSDebug.JMSDotNetT3Server.isDebugEnabled()) break block10;
                        JMSDebug.JMSDotNetT3Server.debug("Failed to disconnect RJVM.", throwable);
                    }
                }
                JMSCSharp.getInstance().remove_connection(this.id);
                t3ConnectionGoneListener = this.listener;
                this.listener = null;
            }
            if (t3ConnectionGoneListener != null) {
                try {
                    t3ConnectionGoneListener.onPeerGone(new T3ConnectionGoneEventImpl(peerGoneEvent));
                }
                catch (Throwable throwable) {
                    if (!JMSDebug.JMSDotNetT3Server.isDebugEnabled()) break block11;
                    JMSDebug.JMSDotNetT3Server.debug("Failed to notify listener. ", throwable);
                }
            }
        }
    }

    public synchronized void shutdown() {
        if (this.closed) {
            return;
        }
        this.closedByClient = true;
        this.listener = null;
        this.peerGone(null);
    }

    private synchronized void check_close() throws IOException {
        if (this.closed) {
            throw new IOException("T3 connection is closed");
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public JVMID getRJVMId() {
        return this.t3rjvm.getRJVM().getID();
    }
}

