/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.jms.JMSException;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;

public final class TransportError
implements MarshalWritable,
MarshalReadable {
    public static final int TYPE_CODE = 20001;
    private Throwable throwable;
    private boolean isRemoteException;
    private ArrayList exceptionArray;

    public TransportError() {
    }

    public TransportError(Throwable throwable) {
        this.throwable = throwable;
        this.isRemoteException = false;
    }

    public TransportError(Throwable throwable, boolean bl) {
        this.throwable = throwable;
        this.isRemoteException = false;
    }

    public TransportError(String string, boolean bl) {
        this.throwable = new RuntimeException(string);
        this.isRemoteException = false;
    }

    public boolean isPeerGone() {
        throw new AssertionError((Object)"not implemented");
    }

    public int getMarshalTypeCode() {
        return 20001;
    }

    public ArrayList getExceptionNames() {
        return this.exceptionArray;
    }

    public boolean IsRemoteException() {
        return this.isRemoteException;
    }

    public void marshal(MarshalWriter marshalWriter) {
        marshalWriter.writeUnsignedByte(1);
        marshalWriter.writeUnsignedByte(0);
        if (this.throwable != null) {
            Throwable throwable;
            ArrayList<String> arrayList = new ArrayList<String>(5);
            arrayList.add(this.throwable.getClass().getName());
            if (this.throwable instanceof JMSException) {
                for (throwable = ((JMSException)this.throwable).getLinkedException(); throwable != null; throwable = throwable.getCause()) {
                    arrayList.add(throwable.getClass().getName());
                }
            }
            if (arrayList.size() == 1) {
                for (throwable = this.throwable.getCause(); throwable != null; throwable = throwable.getCause()) {
                    arrayList.add(throwable.getClass().getName());
                }
            }
            marshalWriter.writeInt(arrayList.size() + 1);
            for (int i = 0; i < arrayList.size(); ++i) {
                marshalWriter.writeString((String)arrayList.get(i));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
            marshalWriter.writeString(byteArrayOutputStream.toString());
        } else {
            marshalWriter.writeString("null");
        }
    }

    public void unmarshal(MarshalReader marshalReader) {
        int n = marshalReader.read();
        while ((marshalReader.readByte() & 1) != 0) {
        }
        this.isRemoteException = true;
        int n2 = marshalReader.readInt();
        for (int i = 0; i < n2 - 1; ++i) {
            this.exceptionArray.add(marshalReader.readString());
        }
        this.throwable = new Throwable(marshalReader.readString());
    }

    public void printStackTrace() {
        if (this.throwable != null) {
            this.throwable.printStackTrace();
        }
    }

    public String toString() {
        return "TransportError:<" + this.throwable + ">";
    }
}

