/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport;

import weblogic.jms.dotnet.transport.ServiceOneWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportAnnouncement;
import weblogic.jms.dotnet.transport.TransportFactoryLock;
import weblogic.jms.dotnet.transport.TransportPluginSPI;
import weblogic.jms.dotnet.transport.TransportThreadPool;
import weblogic.jms.dotnet.transport.internal.TransportImpl;

public class TransportFactory {
    private static ServiceOneWay listener;
    private static final TransportFactoryLock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTransportListener(ServiceOneWay serviceOneWay) {
        TransportFactoryLock transportFactoryLock = lock;
        synchronized (transportFactoryLock) {
            listener = serviceOneWay;
        }
    }

    public static Transport createTransport(TransportPluginSPI transportPluginSPI, TransportThreadPool transportThreadPool) {
        return new TransportImpl(transportPluginSPI, transportThreadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void announceTransport(Transport transport) {
        ServiceOneWay serviceOneWay;
        TransportFactoryLock transportFactoryLock = lock;
        synchronized (transportFactoryLock) {
            serviceOneWay = listener;
        }
        if (serviceOneWay == null) {
            return;
        }
        serviceOneWay.invoke(new TransportAnnouncement(transport));
    }

    static {
        lock = new TransportFactoryLock();
    }
}

