/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.internal;

import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;

class BootstrapRequest
implements MarshalReadable,
MarshalWritable {
    private String bootstrapServiceClassName;
    private int heartBeatInterval = 0;
    private int allowedMissedBeats = 0;

    BootstrapRequest() {
    }

    BootstrapRequest(String string) {
        this.bootstrapServiceClassName = string;
    }

    synchronized String getBootstrapServiceClassName() {
        return this.bootstrapServiceClassName;
    }

    synchronized int getHeartbeatInterval() {
        return this.heartBeatInterval;
    }

    synchronized int getAllowedMissedBeats() {
        return this.allowedMissedBeats;
    }

    public int getMarshalTypeCode() {
        return 20000;
    }

    public void marshal(MarshalWriter marshalWriter) {
        marshalWriter.writeUnsignedByte(1);
        marshalWriter.writeUnsignedByte(0);
        marshalWriter.writeString(this.bootstrapServiceClassName);
        marshalWriter.writeInt(this.heartBeatInterval);
        marshalWriter.writeInt(this.allowedMissedBeats);
    }

    public synchronized void unmarshal(MarshalReader marshalReader) {
        int n = marshalReader.read();
        while ((marshalReader.readByte() & 1) != 0) {
        }
        this.bootstrapServiceClassName = marshalReader.readString();
        this.heartBeatInterval = marshalReader.readInt();
        this.allowedMissedBeats = marshalReader.readInt();
    }
}

