/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.internal;

import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.ReceivedOneWay;
import weblogic.jms.dotnet.transport.SendHandlerOneWay;
import weblogic.jms.dotnet.transport.ServiceOneWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.dotnet.transport.internal.HeartbeatNumberLock;
import weblogic.jms.dotnet.transport.internal.HeartbeatRequest;
import weblogic.jms.dotnet.transport.internal.HeartbeatStateLock;
import weblogic.jms.dotnet.transport.internal.MissedHeartbeatLock;
import weblogic.jms.dotnet.transport.internal.TransportImpl;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

class HeartbeatService
implements ServiceOneWay,
TimerListener {
    static final boolean debug = false;
    private long heartbeatInterval;
    private int allowedMissedBeats;
    private int sentHeartbeatNumber = 0;
    private int recvHeartbeatNumber = -1;
    private int recvHeartbeatNumberOld = -1;
    private int missedHeartbeatCount = 0;
    private Transport transport;
    private Timer heartbeatTimer;
    private RunningState runningState = RunningState.INIT;
    private HeartbeatNumberLock heartbeatNumberLock = new HeartbeatNumberLock();
    private MissedHeartbeatLock missedHeartbeatLock = new MissedHeartbeatLock();
    private HeartbeatStateLock stateLock = new HeartbeatStateLock();
    private TimerManager timerManager;

    HeartbeatService(int n, int n2, Transport transport) {
        this.heartbeatInterval = n;
        if (this.heartbeatInterval < 1000L) {
            this.heartbeatInterval = 1000L;
        }
        this.allowedMissedBeats = n2;
        if (this.allowedMissedBeats < 1) {
            this.allowedMissedBeats = 1;
        }
        this.transport = transport;
        this.timerManager = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startHeartbeat() {
        HeartbeatStateLock heartbeatStateLock = this.stateLock;
        synchronized (heartbeatStateLock) {
            if (this.runningState != RunningState.INIT) {
                return;
            }
            try {
                this.heartbeatTimer = this.timerManager.scheduleAtFixedRate((TimerListener)this, 0L, this.heartbeatInterval);
            }
            catch (IllegalStateException illegalStateException) {
                this.runningState = RunningState.SHUTDOWN;
                return;
            }
            this.runningState = RunningState.RUNNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopHeartbeat() {
        HeartbeatStateLock heartbeatStateLock = this.stateLock;
        synchronized (heartbeatStateLock) {
            if (this.runningState == RunningState.RUNNING) {
                this.heartbeatTimer.cancel();
            }
            this.runningState = RunningState.SHUTDOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetMissCounter() {
        MissedHeartbeatLock missedHeartbeatLock = this.missedHeartbeatLock;
        synchronized (missedHeartbeatLock) {
            this.missedHeartbeatCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        HeartbeatNumberLock heartbeatNumberLock = this.heartbeatNumberLock;
        synchronized (heartbeatNumberLock) {
            this.sendHeartbeatMessage();
            this.checkReceivedRemoteHeartbeat();
        }
    }

    private void sendHeartbeatMessage() {
        SendHandlerOneWay sendHandlerOneWay = this.transport.createOneWay(10001L);
        HeartbeatRequest heartbeatRequest = new HeartbeatRequest(this.sentHeartbeatNumber);
        sendHandlerOneWay.send(heartbeatRequest);
        ++this.sentHeartbeatNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReceivedRemoteHeartbeat() {
        if (this.recvHeartbeatNumber != this.recvHeartbeatNumberOld) {
            this.resetMissCounter();
            this.recvHeartbeatNumberOld = this.recvHeartbeatNumber;
            return;
        }
        MissedHeartbeatLock missedHeartbeatLock = this.missedHeartbeatLock;
        synchronized (missedHeartbeatLock) {
            ++this.missedHeartbeatCount;
            if (this.missedHeartbeatCount <= this.allowedMissedBeats) {
                return;
            }
            TransportError transportError = new TransportError(new Exception("Closing stale connection:  Missed " + this.missedHeartbeatCount + " heartbeat messages " + " with a heartbeat interval of " + this.heartbeatInterval + "ms."));
            ((TransportImpl)this.transport).shutdown(transportError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(ReceivedOneWay receivedOneWay) {
        MarshalReadable marshalReadable = receivedOneWay.getRequest();
        HeartbeatRequest heartbeatRequest = (HeartbeatRequest)marshalReadable;
        HeartbeatNumberLock heartbeatNumberLock = this.heartbeatNumberLock;
        synchronized (heartbeatNumberLock) {
            this.recvHeartbeatNumber = heartbeatRequest.getHeartbeatNumber();
        }
    }

    public void onPeerGone(TransportError transportError) {
        this.stopHeartbeat();
    }

    public void onShutdown() {
        this.stopHeartbeat();
    }

    public void onUnregister() {
        this.stopHeartbeat();
    }

    private void debug(String string) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RunningState {
        INIT,
        RUNNING,
        SHUTDOWN;

    }
}

