/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.internal;

import weblogic.jms.dotnet.transport.TransportExecutable;
import weblogic.jms.dotnet.transport.internal.ExecutableWrapper;
import weblogic.jms.dotnet.transport.internal.OrderLock;
import weblogic.jms.dotnet.transport.internal.ThreadPoolWrapper;

class Order
implements TransportExecutable {
    private ExecutableWrapper first;
    private ExecutableWrapper last;
    private final long ordering;
    private final ThreadPoolWrapper poolWrapper;

    private Order(ThreadPoolWrapper threadPoolWrapper, long l) {
        this.poolWrapper = threadPoolWrapper;
        this.ordering = l;
    }

    private synchronized void add(ExecutableWrapper executableWrapper) {
        if (this.first == null) {
            this.first = executableWrapper;
            this.last = executableWrapper;
            return;
        }
        this.last.next = executableWrapper;
        this.last = executableWrapper;
    }

    private synchronized ExecutableWrapper remove() {
        if (this.first == null) {
            return null;
        }
        ExecutableWrapper executableWrapper = this.first;
        this.first = this.first.next;
        if (this.first == null) {
            this.last = null;
        }
        return executableWrapper;
    }

    private synchronized boolean isEmpty() {
        return this.first == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void schedule(ThreadPoolWrapper threadPoolWrapper, TransportExecutable transportExecutable, long l) {
        Order order;
        ExecutableWrapper executableWrapper = new ExecutableWrapper(transportExecutable);
        OrderLock orderLock = threadPoolWrapper.getLock();
        synchronized (orderLock) {
            order = threadPoolWrapper.getOrder(l);
            if (order != null) {
                order.add(executableWrapper);
                return;
            }
            order = new Order(threadPoolWrapper, l);
            order.add(executableWrapper);
            threadPoolWrapper.putOrder(l, order);
        }
        threadPoolWrapper.schedule(order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        for (int i = 0; i < 10; ++i) {
            ExecutableWrapper executableWrapper = this.remove();
            executableWrapper.getTask().execute();
            if (!this.isEmpty()) continue;
            OrderLock orderLock = this.poolWrapper.getLock();
            synchronized (orderLock) {
                if (this.isEmpty()) {
                    this.poolWrapper.removeOrder(this.ordering);
                    return;
                }
                continue;
            }
        }
        this.poolWrapper.schedule(this);
    }
}

