/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.SendHandlerOneWay;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.dotnet.transport.internal.TransportImpl;

public class SendHandlerOneWayImpl
implements SendHandlerOneWay {
    private AtomicBoolean sentFlag = new AtomicBoolean(false);
    private AtomicBoolean canceledFlag = new AtomicBoolean(false);
    private TransportImpl transportImpl;
    private long remoteServiceId;
    private long remoteOrderingId;

    SendHandlerOneWayImpl(TransportImpl transportImpl, long l, long l2) {
        this.transportImpl = transportImpl;
        this.remoteServiceId = l;
        this.remoteOrderingId = l2;
    }

    long getRemoteServiceID() {
        return this.remoteServiceId;
    }

    long getRemoteOrderingID() {
        return this.remoteOrderingId;
    }

    void checkAlreadySent() {
        if (this.sentFlag.getAndSet(true)) {
            throw new AssertionError((Object)"duplicate send");
        }
    }

    boolean isAlreadySent() {
        return this.sentFlag.get();
    }

    TransportImpl getTransport() {
        return this.transportImpl;
    }

    public void send(MarshalWritable marshalWritable) {
        this.checkAlreadySent();
        if (this.canceledFlag.get()) {
            return;
        }
        this.transportImpl.sendInternalOneWay(this, marshalWritable);
    }

    public void cancel(TransportError transportError) {
        this.canceledFlag.set(true);
    }
}

