/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.internal;

import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.ReceivedOneWay;
import weblogic.jms.dotnet.transport.SendHandlerTwoWay;
import weblogic.jms.dotnet.transport.ServiceOneWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.dotnet.transport.TransportExecutable;
import weblogic.jms.dotnet.transport.TwoWayResponseListener;
import weblogic.jms.dotnet.transport.internal.ReceivedOneWayImpl;
import weblogic.jms.dotnet.transport.internal.ResponseLock;
import weblogic.jms.dotnet.transport.internal.SendHandlerOneWayImpl;
import weblogic.jms.dotnet.transport.internal.ThreadPoolWrapper;
import weblogic.jms.dotnet.transport.internal.TransportImpl;

public class SendHandlerTwoWayImpl
extends SendHandlerOneWayImpl
implements SendHandlerTwoWay,
ServiceOneWay,
TransportExecutable {
    private ResponseLock lock = new ResponseLock();
    private long responseId;
    private long responseOrderingId;
    private int blockingCount;
    private TwoWayResponseListener responseListener;
    private ReceivedOneWayImpl response;
    private static final TransportError CANCEL_ERROR = new TransportError("Canceled", false);
    private static final TransportError SHUTDOWN_ERROR = new TransportError("Shutdown", false);

    SendHandlerTwoWayImpl(TransportImpl transportImpl, long l, long l2, long l3) {
        super(transportImpl, l, l2);
        this.responseId = transportImpl.allocateServiceID();
        this.responseOrderingId = l3;
    }

    private void scheduleMe() {
        this.getTransport().getDefaultThreadPool().schedule(this, this.responseOrderingId);
    }

    long getResponseID() {
        return this.responseId;
    }

    long getResponseOrderingID() {
        return this.responseOrderingId;
    }

    public void send(MarshalWritable marshalWritable) {
        this.send(marshalWritable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MarshalWritable marshalWritable, TwoWayResponseListener twoWayResponseListener) {
        this.checkAlreadySent();
        ResponseLock responseLock = this.lock;
        synchronized (responseLock) {
            this.responseListener = twoWayResponseListener;
            if (this.response != null) {
                if (this.responseListener != null) {
                    this.scheduleMe();
                }
                return;
            }
            this.getTransport().registerService(this.responseId, this, ThreadPoolWrapper.DIRECT);
            if (this.response != null) {
                this.getTransport().unregisterService(this.responseId, (TransportError)this.response.getRequest());
                return;
            }
        }
        this.getTransport().sendInternalTwoWay(this, marshalWritable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarshalReadable getResponse(boolean bl) {
        ResponseLock responseLock = this.lock;
        synchronized (responseLock) {
            if (this.response == null && bl) {
                ++this.blockingCount;
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.setResponse(new TransportError(interruptedException));
                }
                --this.blockingCount;
            }
            if (this.blockingCount > 0) {
                this.lock.notify();
            }
            return this.response.getRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(TransportError transportError) {
        if (transportError == null) {
            transportError = CANCEL_ERROR;
        }
        ResponseLock responseLock = this.lock;
        synchronized (responseLock) {
            if (this.response == null) {
                this.setResponse(transportError);
                this.getTransport().unregisterService(this.responseId, transportError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ReceivedOneWayImpl receivedOneWayImpl;
        TwoWayResponseListener twoWayResponseListener;
        ResponseLock responseLock = this.lock;
        synchronized (responseLock) {
            twoWayResponseListener = this.responseListener;
            receivedOneWayImpl = this.response;
        }
        twoWayResponseListener.onResponse(receivedOneWayImpl);
    }

    private void setResponse(MarshalReadable marshalReadable) {
        this.setResponse(new ReceivedOneWayImpl((Transport)this.getTransport(), this.getRemoteServiceID(), marshalReadable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponse(ReceivedOneWayImpl receivedOneWayImpl) {
        TwoWayResponseListener twoWayResponseListener;
        ResponseLock responseLock = this.lock;
        synchronized (responseLock) {
            if (this.response != null) {
                return;
            }
            this.response = receivedOneWayImpl;
            if (this.blockingCount > 0) {
                this.lock.notify();
            }
            twoWayResponseListener = this.responseListener;
        }
        if (twoWayResponseListener != null) {
            this.scheduleMe();
        }
        this.getTransport().unregisterServiceSilent(this.responseId);
    }

    public void invoke(ReceivedOneWay receivedOneWay) {
        this.setResponse((ReceivedOneWayImpl)receivedOneWay);
    }

    public void onPeerGone(TransportError transportError) {
        this.setResponse(transportError);
    }

    public void onShutdown() {
        this.setResponse(SHUTDOWN_ERROR);
    }

    public void onUnregister() {
        this.setResponse(CANCEL_ERROR);
    }
}

