/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.internal;

import weblogic.jms.dotnet.transport.Service;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.dotnet.transport.internal.ReceivedOneWayImpl;
import weblogic.jms.dotnet.transport.internal.ReceivedTwoWayImpl;
import weblogic.jms.dotnet.transport.internal.ServiceExecuteOneWay;
import weblogic.jms.dotnet.transport.internal.ServiceExecutePeerGone;
import weblogic.jms.dotnet.transport.internal.ServiceExecuteShutdown;
import weblogic.jms.dotnet.transport.internal.ServiceExecuteTwoWay;
import weblogic.jms.dotnet.transport.internal.ServiceExecuteUnregister;
import weblogic.jms.dotnet.transport.internal.ThreadPoolWrapper;

class ServiceWrapper {
    private final ThreadPoolWrapper threadPool;
    private final Service service;
    private final long serviceID;
    private boolean closed;

    ServiceWrapper(long l, Service service2, ThreadPoolWrapper threadPoolWrapper) {
        this.service = service2;
        this.threadPool = threadPoolWrapper;
        this.serviceID = l;
    }

    Service getService() {
        return this.service;
    }

    synchronized void invoke(ReceivedOneWayImpl receivedOneWayImpl, long l) {
        if (this.closed) {
            return;
        }
        this.threadPool.schedule(new ServiceExecuteOneWay(this, receivedOneWayImpl), l);
    }

    synchronized void invoke(ReceivedTwoWayImpl receivedTwoWayImpl, long l) {
        if (this.closed) {
            return;
        }
        this.threadPool.schedule(new ServiceExecuteTwoWay(this, receivedTwoWayImpl), l);
    }

    synchronized void shutdown(TransportError transportError) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (transportError != null) {
            this.threadPool.schedule(new ServiceExecutePeerGone(this, transportError));
        } else {
            this.threadPool.schedule(new ServiceExecuteShutdown(this));
        }
    }

    synchronized void unregister() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.threadPool.schedule(new ServiceExecuteUnregister(this));
    }

    public synchronized String toString() {
        return "ServiceWrapper:<" + this.serviceID + "," + this.service + ">";
    }
}

