/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.internal;

import weblogic.jms.dotnet.transport.TransportExecutable;
import weblogic.jms.dotnet.transport.TransportThreadPool;
import weblogic.jms.dotnet.transport.internal.DirectThreadPool;
import weblogic.jms.dotnet.transport.internal.Order;
import weblogic.jms.dotnet.transport.internal.OrderLock;
import weblogic.utils.collections.NumericKeyHashMap;

class ThreadPoolWrapper {
    static final ThreadPoolWrapper DIRECT = new ThreadPoolWrapper(new DirectThreadPool());
    private final TransportThreadPool poolActual;
    private final OrderLock lock = new OrderLock();
    private NumericKeyHashMap orderings = new NumericKeyHashMap();

    ThreadPoolWrapper(TransportThreadPool transportThreadPool) {
        this.poolActual = transportThreadPool;
    }

    void schedule(TransportExecutable transportExecutable) {
        this.poolActual.schedule(transportExecutable);
    }

    void schedule(TransportExecutable transportExecutable, long l) {
        if (l == -1L) {
            this.poolActual.schedule(transportExecutable);
        } else {
            Order.schedule(this, transportExecutable, l);
        }
    }

    OrderLock getLock() {
        return this.lock;
    }

    void removeOrder(long l) {
        this.orderings.remove(l);
    }

    Order getOrder(long l) {
        return (Order)this.orderings.get(l);
    }

    void putOrder(long l, Order order) {
        this.orderings.put(l, (Object)order);
    }
}

