/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.internal;

import java.util.concurrent.atomic.AtomicLong;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalReadableFactory;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.dotnet.transport.Service;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.dotnet.transport.TransportPluginSPI;
import weblogic.jms.dotnet.transport.TransportThreadPool;
import weblogic.jms.dotnet.transport.internal.BootstrapRequest;
import weblogic.jms.dotnet.transport.internal.BootstrapService;
import weblogic.jms.dotnet.transport.internal.HeartbeatLock;
import weblogic.jms.dotnet.transport.internal.HeartbeatService;
import weblogic.jms.dotnet.transport.internal.MarshalFactoryImpl;
import weblogic.jms.dotnet.transport.internal.MarshalLock;
import weblogic.jms.dotnet.transport.internal.ReceivedOneWayImpl;
import weblogic.jms.dotnet.transport.internal.ReceivedTwoWayImpl;
import weblogic.jms.dotnet.transport.internal.SendHandlerOneWayImpl;
import weblogic.jms.dotnet.transport.internal.SendHandlerTwoWayImpl;
import weblogic.jms.dotnet.transport.internal.ServiceLock;
import weblogic.jms.dotnet.transport.internal.ServiceWrapper;
import weblogic.jms.dotnet.transport.internal.ThreadPoolWrapper;
import weblogic.utils.collections.NumericKeyHashMap;

public class TransportImpl
implements Transport {
    private static final long UNUSED = -1L;
    private AtomicLong nextServiceId = new AtomicLong(-10L);
    private final ThreadPoolWrapper defaultThreadPool;
    private final TransportPluginSPI plugin;
    private boolean closed;
    private TransportError closedReason;
    private HeartbeatLock hLock = new HeartbeatLock();
    private HeartbeatService heartbeatService;
    private MarshalLock mLock = new MarshalLock();
    private MarshalReadableFactory[] readableFactories = new MarshalReadableFactory[0];
    private ServiceLock sLock = new ServiceLock();
    private NumericKeyHashMap services = new NumericKeyHashMap();
    private static final byte FLAG_EXT = 1;
    private static final byte FLAG_ISTWOWAY = 2;
    private static final byte FLAG_ISONEWAY = 4;
    private static final byte FLAG_REMOTEORDERED = 8;
    private static final byte FLAG_RESPONSEORDERED = 16;

    public TransportImpl(TransportPluginSPI transportPluginSPI, TransportThreadPool transportThreadPool) {
        this.plugin = transportPluginSPI;
        this.defaultThreadPool = new ThreadPoolWrapper(transportThreadPool);
        this.addMarshalReadableFactory(new MarshalFactoryImpl());
        this.registerService(10003L, new BootstrapService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n;
        int n2;
        long l = this.nextServiceId.get();
        Object object = this.mLock;
        synchronized (object) {
            n2 = this.readableFactories.length;
        }
        object = this.sLock;
        synchronized (object) {
            n = this.services.size();
        }
        return "Transport<plg=" + this.plugin + ", svcs= " + n + ", facts= " + n2 + ", nextId= " + l + ">";
    }

    ThreadPoolWrapper getDefaultThreadPool() {
        return this.defaultThreadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startHeartbeatService(BootstrapRequest bootstrapRequest) {
        HeartbeatService heartbeatService = null;
        HeartbeatLock heartbeatLock = this.hLock;
        synchronized (heartbeatLock) {
            if (this.heartbeatService != null) {
                return;
            }
            int n = bootstrapRequest.getHeartbeatInterval();
            int n2 = bootstrapRequest.getAllowedMissedBeats();
            if (n <= 0 || n2 <= 0) {
                return;
            }
            heartbeatService = this.heartbeatService = new HeartbeatService(n, n2, this);
        }
        this.registerService(10001L, heartbeatService);
        heartbeatService.startHeartbeat();
    }

    public long allocateServiceID() {
        return this.nextServiceId.getAndDecrement();
    }

    public SendHandlerOneWayImpl createOneWay(long l) {
        return new SendHandlerOneWayImpl(this, l, -1L);
    }

    public SendHandlerOneWayImpl createOneWay(long l, long l2) {
        return new SendHandlerOneWayImpl(this, l, l2);
    }

    public SendHandlerTwoWayImpl createTwoWay(long l) {
        return this.createTwoWay(l, -1L, -1L);
    }

    public SendHandlerTwoWayImpl createTwoWay(long l, long l2) {
        return this.createTwoWay(l, l2, -1L);
    }

    public SendHandlerTwoWayImpl createTwoWay(long l, long l2, long l3) {
        return new SendHandlerTwoWayImpl(this, l, l2, l3);
    }

    public MarshalReadable bootstrap(String string) {
        SendHandlerTwoWayImpl sendHandlerTwoWayImpl = this.createTwoWay(10003L);
        BootstrapRequest bootstrapRequest = new BootstrapRequest(string);
        sendHandlerTwoWayImpl.send(bootstrapRequest);
        return sendHandlerTwoWayImpl.getResponse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMarshalReadableFactory(MarshalReadableFactory marshalReadableFactory) {
        if (marshalReadableFactory == null) {
            return;
        }
        MarshalLock marshalLock = this.mLock;
        synchronized (marshalLock) {
            MarshalReadableFactory[] marshalReadableFactoryArray = this.readableFactories;
            this.readableFactories = new MarshalReadableFactory[marshalReadableFactoryArray.length + 1];
            System.arraycopy(marshalReadableFactoryArray, 0, this.readableFactories, 0, marshalReadableFactoryArray.length);
            this.readableFactories[marshalReadableFactoryArray.length] = marshalReadableFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarshalReadable createMarshalReadable(int n) {
        MarshalLock marshalLock = this.mLock;
        synchronized (marshalLock) {
            for (MarshalReadableFactory marshalReadableFactory : this.readableFactories) {
                MarshalReadable marshalReadable = marshalReadableFactory.createMarshalReadable(n);
                if (marshalReadable == null) continue;
                return marshalReadable;
            }
        }
        throw new RuntimeException("Unknown marshal type code " + n);
    }

    public long getScratchId() {
        return this.plugin.getScratchID();
    }

    public void registerService(long l, Service service2) {
        this.registerService(l, service2, this.defaultThreadPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerService(long l, Service service2, ThreadPoolWrapper threadPoolWrapper) {
        ServiceWrapper serviceWrapper = new ServiceWrapper(l, service2, threadPoolWrapper);
        ServiceLock serviceLock = this.sLock;
        synchronized (serviceLock) {
            if (this.closed) {
                serviceWrapper.shutdown(this.closedReason);
                return;
            }
            if (this.services.get(l) != null) {
                throw new RuntimeException("Duplicate service-id " + l);
            }
            this.services.put(l, (Object)serviceWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(TransportError transportError) {
        Object[] objectArray;
        Object object = this.sLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closedReason = transportError;
            this.closed = true;
            objectArray = this.services.values().toArray();
            this.services.clear();
        }
        Object[] objectArray2 = this.hLock;
        synchronized (this.hLock) {
            object = this.heartbeatService;
            // ** MonitorExit[var4_5] (shouldn't be in output)
            if (object != null) {
                ((HeartbeatService)object).stopHeartbeat();
            }
            try {
                this.plugin.terminateConnection();
            }
            catch (Exception exception) {
                for (Object object2 : objectArray) {
                    ((ServiceWrapper)object2).shutdown(transportError);
                }
            }
            finally {
                for (Object object3 : objectArray) {
                    ((ServiceWrapper)object3).shutdown(transportError);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(long l) {
        ServiceWrapper serviceWrapper;
        ServiceLock serviceLock = this.sLock;
        synchronized (serviceLock) {
            serviceWrapper = (ServiceWrapper)this.services.remove(l);
        }
        if (serviceWrapper != null) {
            serviceWrapper.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterService(long l, TransportError transportError) {
        ServiceWrapper serviceWrapper;
        ServiceLock serviceLock = this.sLock;
        synchronized (serviceLock) {
            serviceWrapper = (ServiceWrapper)this.services.remove(l);
        }
        if (serviceWrapper != null) {
            serviceWrapper.shutdown(transportError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterServiceSilent(long l) {
        ServiceLock serviceLock = this.sLock;
        synchronized (serviceLock) {
            this.services.remove(l);
        }
    }

    void sendInternalOneWay(SendHandlerOneWayImpl sendHandlerOneWayImpl, MarshalWritable marshalWritable) {
        MarshalWriter marshalWriter = this.plugin.createMarshalWriter();
        byte by = 4;
        if (sendHandlerOneWayImpl.getRemoteOrderingID() != -1L) {
            by = (byte)(by | 8);
        }
        marshalWriter.writeByte(by);
        marshalWriter.writeLong(sendHandlerOneWayImpl.getRemoteServiceID());
        if (sendHandlerOneWayImpl.getRemoteOrderingID() != -1L) {
            marshalWriter.writeLong(sendHandlerOneWayImpl.getRemoteOrderingID());
        }
        marshalWriter.writeMarshalable(marshalWritable);
        this.plugin.send(marshalWriter);
    }

    void sendInternalTwoWay(SendHandlerTwoWayImpl sendHandlerTwoWayImpl, MarshalWritable marshalWritable) {
        MarshalWriter marshalWriter = this.plugin.createMarshalWriter();
        byte by = 2;
        if (sendHandlerTwoWayImpl.getRemoteOrderingID() != -1L) {
            by = (byte)(by | 8);
        }
        if (sendHandlerTwoWayImpl.getResponseOrderingID() != -1L) {
            by = (byte)(by | 0x10);
        }
        marshalWriter.writeByte(by);
        marshalWriter.writeLong(sendHandlerTwoWayImpl.getRemoteServiceID());
        if (sendHandlerTwoWayImpl.getRemoteOrderingID() != -1L) {
            marshalWriter.writeLong(sendHandlerTwoWayImpl.getRemoteOrderingID());
        }
        marshalWriter.writeLong(sendHandlerTwoWayImpl.getResponseID());
        if (sendHandlerTwoWayImpl.getResponseOrderingID() != -1L) {
            marshalWriter.writeLong(sendHandlerTwoWayImpl.getResponseOrderingID());
        }
        marshalWriter.writeMarshalable(marshalWritable);
        this.plugin.send(marshalWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(MarshalReader marshalReader) {
        ServiceWrapper serviceWrapper;
        int n;
        int n2 = n = marshalReader.read();
        while ((n2 & 1) != 0) {
            n2 = marshalReader.read();
        }
        long l = marshalReader.readLong();
        Object object = this.sLock;
        synchronized (object) {
            serviceWrapper = (ServiceWrapper)this.services.get(l);
        }
        if (serviceWrapper == null) {
            marshalReader.internalClose();
            return;
        }
        Object object2 = this.hLock;
        synchronized (object2) {
            object = this.heartbeatService;
        }
        if (object != null) {
            ((HeartbeatService)object).resetMissCounter();
        }
        long l2 = (n & 8) != 0 ? marshalReader.readLong() : -1L;
        if ((n & 4) != 0) {
            object2 = new ReceivedOneWayImpl((Transport)this, l, marshalReader);
            serviceWrapper.invoke((ReceivedOneWayImpl)object2, l2);
            return;
        }
        if ((n & 2) != 0) {
            long l3 = marshalReader.readLong();
            long l4 = (n & 0x10) != 0 ? marshalReader.readLong() : -1L;
            SendHandlerOneWayImpl sendHandlerOneWayImpl = this.createOneWay(l3, l4);
            ReceivedTwoWayImpl receivedTwoWayImpl = new ReceivedTwoWayImpl(this, l, marshalReader, sendHandlerOneWayImpl);
            serviceWrapper.invoke(receivedTwoWayImpl, l2);
            return;
        }
        throw new AssertionError();
    }
}

