/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.socketplugin;

public class Chunk {
    private static final int CHUNK_SIZE = 4096;
    private static Chunk head;
    private boolean isFree;
    private Chunk next;
    private byte[] buf;
    private static int allocated;
    private static int freed;

    private Chunk(int n) {
        this.buf = new byte[n];
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public static synchronized Chunk alloc() {
        Chunk chunk = head;
        if (head != null) {
            head = Chunk.head.next;
            chunk.isFree = false;
            return chunk;
        }
        System.out.println("Allocating new Chunk, alloc count=" + ++allocated + "free count=" + freed);
        return new Chunk(4096);
    }

    private static synchronized void free(Chunk chunk) {
        ++freed;
        if (chunk.isFree) {
            throw new AssertionError();
        }
        chunk.isFree = true;
        chunk.next = head;
        head = chunk;
    }

    public void free() {
        Chunk.free(this);
    }

    static {
        for (int i = 0; i < 10000; ++i) {
            Chunk chunk = new Chunk(4096);
            Chunk.free(chunk);
        }
    }
}

