/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.socketplugin;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalReader;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.socketplugin.Chunk;
import weblogic.utils.StringUtils;

public class ChunkInputStream
extends InputStream
implements MarshalReader,
DataInput {
    private Chunk c = Chunk.alloc();
    private byte[] buf = this.c.getBuffer();
    private int pos;
    private int offset;
    private int count = this.buf.length;
    private Transport transport;

    ChunkInputStream(Transport transport) {
        this.transport = transport;
    }

    void checkEOF(int n) {
        if (this.pos + n > this.count) {
            throw new RuntimeException("EOF");
        }
    }

    byte[] getBuf() {
        return this.buf;
    }

    public void internalClose() {
        if (this.c == null) {
            return;
        }
        this.c.free();
        this.c = null;
        this.buf = null;
    }

    void setCount(int n) {
        this.count = n;
    }

    int size() {
        return this.count;
    }

    void setPos(int n) {
        this.pos = n;
    }

    public long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    int getPosition() {
        return this.pos;
    }

    public int available() {
        return this.count - this.pos;
    }

    public void reset() {
        this.pos = this.offset;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public MarshalReadable readMarshalable() {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.pos + n2;
        if (this.pos + n2 > this.count) {
            throw new RuntimeException("EOF detected. Stream does not have enough bytes for reading entire MarshalReadable object(Marshal type code=" + n + ")");
        }
        MarshalReadable marshalReadable = this.transport.createMarshalReadable(n);
        marshalReadable.unmarshal(this);
        if (this.pos < n3) {
            this.skip(n3 - this.pos);
        }
        return marshalReadable;
    }

    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public byte readByte() {
        this.checkEOF(1);
        return this.buf[this.pos++];
    }

    public int readUnsignedByte() {
        this.checkEOF(1);
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public boolean readBoolean() {
        this.checkEOF(1);
        return this.buf[this.pos++] != 0;
    }

    public short readShort() {
        this.checkEOF(2);
        int n = ((short)(this.buf[this.pos] & 0xFF) << 8) + ((short)(this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return (short)n;
    }

    public char readChar() {
        this.checkEOF(2);
        int n = ((this.buf[this.pos] & 0xFF) << 8) + ((this.buf[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        return (char)n;
    }

    public int readInt() {
        this.checkEOF(4);
        int n = ((this.buf[this.pos] & 0xFF) << 24) + ((this.buf[this.pos + 1] & 0xFF) << 16) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 0);
        this.pos += 4;
        return n;
    }

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readString() {
        int n = this.readInt();
        char[] cArray = new char[n];
        this.checkEOF(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (((n3 = this.buf[this.pos++] & 0xFF) & 0x80) != 0) {
                int n4;
                if ((n3 & 0xE0) == 192) {
                    n4 = this.buf[this.pos++] & 0xFF;
                    n3 = ((n3 & 0x1F) << 6) + (n4 & 0x3F);
                } else {
                    n4 = this.buf[this.pos++] & 0xFF;
                    int n5 = this.buf[this.pos++] & 0xFF;
                    n3 = ((n3 & 0xF) << 12) + ((n4 & 0x3F) << 6) + (n5 & 0x3F);
                }
            }
            cArray[n2++] = (char)n3;
        }
        return StringUtils.getString((char[])cArray, (int)0, (int)n2);
    }

    public byte[] readStringAsBytes() {
        int n = this.readInt();
        this.checkEOF(n);
        this.pos -= 4;
        byte[] byArray = new byte[n + 4];
        this.read(byArray, 0, byArray.length);
        return byArray;
    }

    public DataInput getDataInputStream() {
        return this;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException("unresolvable");
    }

    public void readFully(byte[] byArray) throws IOException {
        throw new IOException("unresolvable");
    }

    public String readLine() throws IOException {
        throw new IOException("unresolvable");
    }

    public int readUnsignedShort() throws IOException {
        throw new IOException("unresolvable");
    }

    public String readUTF() throws IOException {
        throw new IOException("unresolvable");
    }

    public int skipBytes(int n) throws IOException {
        throw new IOException("unresolvable");
    }
}

