/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.socketplugin;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.socketplugin.Chunk;

public class ChunkOutputStream
extends OutputStream
implements MarshalWriter,
DataOutput {
    private Chunk c = Chunk.alloc();
    private byte[] buf = this.c.getBuffer();
    private int count;
    private Transport transport;

    ChunkOutputStream(Transport transport) {
        this.transport = transport;
    }

    byte[] getBuf() {
        return this.buf;
    }

    public void internalClose() {
        if (this.c == null) {
            return;
        }
        this.c.free();
        this.c = null;
        this.buf = null;
    }

    void reset() {
        this.count = 0;
    }

    public void reposition(int n) {
        this.count = n;
    }

    public int size() {
        return this.count;
    }

    int getPosition() {
        return this.count;
    }

    void skip(int n) {
        this.count += n;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void writeMarshalable(MarshalWritable marshalWritable) {
        this.writeInt(marshalWritable.getMarshalTypeCode());
        int n = this.count;
        this.writeInt(Integer.MIN_VALUE);
        int n2 = this.count;
        marshalWritable.marshal(this);
        int n3 = this.count;
        int n4 = n3 - n2;
        this.buf[n] = (byte)(n4 >>> 24);
        this.buf[n + 1] = (byte)(n4 >>> 16);
        this.buf[n + 2] = (byte)(n4 >>> 8);
        this.buf[n + 3] = (byte)(n4 >>> 0);
    }

    public void writeByte(byte by) {
        this.buf[this.count++] = by;
    }

    public void writeUnsignedByte(int n) {
        this.buf[this.count++] = (byte)(n & 0xFF);
    }

    public void write(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public void writeBoolean(boolean bl) {
        this.buf[this.count++] = (byte)(bl ? 1 : 0);
    }

    public void writeShort(short s) {
        this.buf[this.count++] = (byte)(s >>> 8);
        this.buf[this.count++] = (byte)(s >>> 0);
    }

    public void writeChar(char c) {
        this.buf[this.count++] = (byte)(c >>> 8);
        this.buf[this.count++] = (byte)(c >>> 0);
    }

    public void writeInt(int n) {
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public void writeLong(long l) {
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)(l >>> 0);
    }

    public void writeFloat(float f) {
        int n = Float.floatToIntBits(f);
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public void writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)(l >>> 0);
    }

    public void writeString(String string) {
        int n;
        int n2 = string.length();
        int n3 = this.count;
        this.count += 4;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if ((c & 0xFF80) == 0) {
                this.buf[this.count++] = (byte)c;
                continue;
            }
            if ((c & 0xF800) == 0) {
                this.buf[this.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buf[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buf[this.count++] = (byte)(0xE0 | c >> 12 & 0xF);
            this.buf[this.count++] = (byte)(0x80 | c >> 6 & 0x3F);
            this.buf[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        n = this.count - n3 - 4;
        this.reposition(n3);
        this.writeInt(n);
        this.skip(n);
    }

    public DataOutput getDataOutputStream() {
        return this;
    }

    public void writeByte(int n) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeBytes(String string) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeChar(int n) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeChars(String string) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeShort(int n) throws IOException {
        throw new IOException("unresolvable");
    }

    public void writeUTF(String string) throws IOException {
        throw new IOException("unresolvable");
    }

    public void write(int n) throws IOException {
        throw new IOException("unresolvable");
    }
}

