/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.socketplugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import weblogic.jms.dotnet.transport.MarshalReadableFactory;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.dotnet.transport.TransportFactory;
import weblogic.jms.dotnet.transport.TransportPluginSPI;
import weblogic.jms.dotnet.transport.TransportThreadPool;
import weblogic.jms.dotnet.transport.socketplugin.ChunkInputStream;
import weblogic.jms.dotnet.transport.socketplugin.ChunkOutputStream;
import weblogic.jms.dotnet.transport.socketplugin.PlainSocketServer;
import weblogic.jms.dotnet.transport.socketplugin.Stats;

public class PlainSocket
implements Runnable,
TransportPluginSPI {
    static final int HEADER_SIZE = 32;
    static final int HEADER_SIZE_POS = 0;
    private InputStream is;
    private OutputStream os;
    private boolean started;
    private final Stats stats;
    private final Transport transport;
    private final MarshalReadableFactory marshalReadableFactory;
    private final TransportThreadPool pool;
    private Socket workerSocket;

    PlainSocket(Stats stats, MarshalReadableFactory marshalReadableFactory, TransportThreadPool transportThreadPool) throws Exception {
        this.stats = stats;
        this.marshalReadableFactory = marshalReadableFactory;
        this.pool = transportThreadPool;
        this.transport = TransportFactory.createTransport(this, transportThreadPool);
        this.transport.addMarshalReadableFactory(marshalReadableFactory);
    }

    public String toString() {
        return "PlainSocket";
    }

    public static Transport startClient(String string, int n, MarshalReadableFactory marshalReadableFactory, TransportThreadPool transportThreadPool) throws Exception {
        PlainSocket plainSocket = new PlainSocket(new Stats("Client"), marshalReadableFactory, transportThreadPool);
        plainSocket.start(new Socket(string, n));
        return plainSocket.transport;
    }

    public static void startServer(int n, TransportThreadPool transportThreadPool) throws Exception {
        PlainSocketServer plainSocketServer = new PlainSocketServer(n, null, transportThreadPool);
        Thread thread2 = new Thread(plainSocketServer);
        thread2.setDaemon(true);
        thread2.start();
    }

    public MarshalWriter createMarshalWriter() {
        try {
            ChunkOutputStream chunkOutputStream = new ChunkOutputStream(this.transport);
            chunkOutputStream.reposition(32);
            return chunkOutputStream;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    void start(Socket socket) throws Exception {
        if (this.started) {
            throw new AssertionError();
        }
        this.workerSocket = socket;
        this.started = true;
        this.is = socket.getInputStream();
        this.os = socket.getOutputStream();
        Thread thread2 = new Thread(this);
        thread2.setDaemon(true);
        thread2.start();
    }

    public void run() {
        block4: while (true) {
            try {
                while (true) {
                    ChunkInputStream chunkInputStream = this.recv();
                    chunkInputStream.skip(32 - chunkInputStream.getPosition());
                    try {
                        this.transport.dispatch(chunkInputStream);
                        continue block4;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.transport.shutdown(new TransportError(throwable));
                return;
            }
        }
    }

    public synchronized void send(MarshalWriter marshalWriter) {
        ChunkOutputStream chunkOutputStream = (ChunkOutputStream)marshalWriter;
        int n = chunkOutputStream.size();
        chunkOutputStream.reposition(0);
        chunkOutputStream.writeInt(n);
        chunkOutputStream.reposition(n);
        try {
            this.os.write(chunkOutputStream.getBuf(), 0, chunkOutputStream.size());
            this.os.flush();
            this.stats.incSend(n);
        }
        catch (Throwable throwable) {
            this.transport.shutdown(new TransportError(throwable));
        }
        chunkOutputStream.internalClose();
    }

    private ChunkInputStream recv() throws Exception {
        int n;
        ChunkInputStream chunkInputStream = new ChunkInputStream(this.transport);
        byte[] byArray = chunkInputStream.getBuf();
        int n2 = 0;
        while (4 - n2 > 0) {
            n = this.is.read(byArray, n2, 4 - n2);
            n2 += n;
        }
        n = chunkInputStream.readInt() - 4;
        while (n - n2 + 4 > 0) {
            int n3 = this.is.read(byArray, n2, n - n2 + 4);
            n2 += n3;
        }
        this.stats.incRecv(n);
        chunkInputStream.setCount(n + 4);
        return chunkInputStream;
    }

    public long getScratchID() {
        return -1L;
    }

    public void terminateConnection() {
        try {
            if (this.workerSocket != null) {
                this.workerSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

