/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.socketplugin;

import java.net.ServerSocket;
import java.net.Socket;
import weblogic.jms.dotnet.transport.MarshalReadableFactory;
import weblogic.jms.dotnet.transport.TransportThreadPool;
import weblogic.jms.dotnet.transport.socketplugin.PlainSocket;
import weblogic.jms.dotnet.transport.socketplugin.Stats;

class PlainSocketServer
implements Runnable {
    private final int port;
    private final ServerSocket serverSocket;
    private final MarshalReadableFactory marshalReadableFactory;
    private final Stats stats = new Stats("Server");
    private final TransportThreadPool pool;

    PlainSocketServer(int n, MarshalReadableFactory marshalReadableFactory, TransportThreadPool transportThreadPool) throws Exception {
        this.port = n;
        this.marshalReadableFactory = marshalReadableFactory;
        this.pool = transportThreadPool;
        this.serverSocket = new ServerSocket(n);
    }

    public void run() {
        try {
            while (true) {
                Socket socket = this.serverSocket.accept();
                PlainSocket plainSocket = new PlainSocket(this.stats, this.marshalReadableFactory, this.pool);
                plainSocket.start(socket);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }
}

