/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.socketplugin;

class Stats
implements Cloneable {
    long recvBytes;
    long recvPackets;
    long sendBytes;
    long sendPackets;
    long startTime = System.currentTimeMillis();
    long curTime;
    long nextTime = this.startTime + 2000L;
    String text = "";

    Stats(String string) {
        this.text = string;
    }

    boolean timeToReport() {
        this.curTime = System.currentTimeMillis();
        if (this.curTime < this.nextTime) {
            return false;
        }
        this.nextTime += 2000L;
        return true;
    }

    synchronized boolean _incRecv(long l) {
        ++this.recvPackets;
        this.recvBytes += l;
        return this.timeToReport();
    }

    synchronized boolean _incSend(long l) {
        ++this.sendPackets;
        this.sendBytes += l;
        return this.timeToReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        Stats stats = this;
        synchronized (stats) {
            Stats stats2 = (Stats)super.clone();
            this.startTime = stats2.curTime = System.currentTimeMillis();
            this.sendPackets = 0L;
            this.sendBytes = 0L;
            this.recvPackets = 0L;
            this.recvBytes = 0L;
            return stats2;
        }
    }

    void printMe() {
        try {
            System.out.println(this.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    void incRecv(long l) {
        if (this._incRecv(l)) {
            this.printMe();
        }
    }

    void incSend(long l) {
        if (this._incSend(l)) {
            this.printMe();
        }
    }

    public String toString() {
        long l = this.curTime - this.startTime;
        double d = (double)l / 1000.0;
        if (d == 0.0) {
            return "Div0";
        }
        return "\nStats " + this.text + "\nsecs=" + d + " recv/sec=" + (double)this.recvPackets / d + "\nsecs=" + d + " recvB/sec=" + (double)this.recvBytes / d + "\nsecs=" + d + " send/sec=" + (double)this.sendPackets / d + "\nsecs=" + d + " sendB/sec=" + (double)this.sendBytes / d + "\n";
    }
}

