/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3client;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.MarshalWriter;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedDataOutputStream;

public class MarshalWriterImpl
implements MarshalWriter {
    private final ChunkedDataOutputStream cdos = new ChunkedDataOutputStream();
    private final Throwable throwable = null;
    private Transport transport;
    private boolean isClosed;
    private MarshalWriterImpl next;

    MarshalWriterImpl() {
        this.transport = null;
    }

    MarshalWriterImpl(Transport transport) {
        this.transport = transport;
    }

    void setNext(MarshalWriterImpl marshalWriterImpl) {
        this.next = marshalWriterImpl;
    }

    MarshalWriterImpl getNext() {
        return this.next;
    }

    void copyTo(OutputStream outputStream) throws IOException {
        this.isClosed = true;
        Chunk chunk = this.cdos.getChunks();
        while (chunk != null) {
            try {
                if (chunk.end > 0) {
                    outputStream.write(chunk.buf, 0, chunk.end);
                }
            }
            catch (IOException iOException) {
                while (chunk != null) {
                    Chunk chunk2 = chunk;
                    chunk = chunk.next;
                    Chunk.releaseChunk((Chunk)chunk2);
                }
                throw iOException;
            }
            Chunk chunk3 = chunk;
            chunk = chunk.next;
            Chunk.releaseChunk((Chunk)chunk3);
        }
    }

    byte[] toByteArray() {
        byte[] byArray = new byte[this.getPosition()];
        int n = 0;
        this.isClosed = true;
        Chunk chunk = this.cdos.getChunks();
        while (chunk != null) {
            if (chunk.end > 0) {
                System.arraycopy(chunk.buf, 0, byArray, n, chunk.end);
                n += chunk.end;
            }
            Chunk chunk2 = chunk;
            chunk = chunk.next;
            Chunk.releaseChunk((Chunk)chunk2);
        }
        return byArray;
    }

    int getPosition() {
        return this.cdos.getPosition();
    }

    void setPosition(int n) {
        this.cdos.setPosition(n);
    }

    void skip(int n) {
        this.cdos.skip(n);
    }

    void writeUTF(String string) {
        try {
            this.cdos.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void writeMarshalable(MarshalWritable marshalWritable) {
        this.writeInt(marshalWritable.getMarshalTypeCode());
        int n = this.cdos.getPosition();
        this.writeInt(Integer.MIN_VALUE);
        int n2 = this.cdos.getPosition();
        marshalWritable.marshal(this);
        int n3 = this.cdos.getPosition();
        int n4 = n3 - n2;
        this.cdos.setPosition(n);
        this.writeInt(n4);
        this.cdos.setPosition(n3);
    }

    public void writeByte(byte by) {
        this.cdos.writeByte((int)by);
    }

    public void writeUnsignedByte(int n) {
        this.cdos.writeByte((int)((byte)(n & 0xFF)));
    }

    void write(int n) {
        this.cdos.writeByte((int)((byte)(n & 0xFF)));
    }

    public void write(byte[] byArray, int n, int n2) {
        this.cdos.write(byArray, n, n2);
    }

    public void writeBoolean(boolean bl) {
        this.cdos.writeBoolean(bl);
    }

    void writeShort(int n) {
        this.cdos.writeShort(n);
    }

    public void writeShort(short s) {
        this.cdos.writeShort((int)s);
    }

    public void writeChar(char c) {
        this.cdos.writeChar((int)c);
    }

    public void writeInt(int n) {
        this.cdos.writeInt(n);
    }

    public void writeLong(long l) {
        this.cdos.writeLong(l);
    }

    public void writeFloat(float f) {
        this.cdos.writeFloat(f);
    }

    public void writeDouble(double d) {
        this.cdos.writeDouble(d);
    }

    public void writeString(String string) {
        this.cdos.writeUTF8(string);
    }

    void closeInternal() {
        if (this.isClosed) {
            return;
        }
        try {
            this.cdos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DataOutput getDataOutputStream() {
        return this.cdos;
    }
}

