/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3client;

import weblogic.jms.dotnet.transport.t3client.MarshalWriterImpl;

class T3 {
    static String PROTOCOL_NAME = "t3";
    static String PROTOCOL_DELIMITER = "\n";
    static String PROTOCOL_ABBV = "AS";
    static String PROTOCOL_ABBV_DELIMITER = ":";
    static int PROTOCOL_ABBV_SIZE = 255;
    static String PROTOCOL_HDR = "HL";
    static String PROTOCOL_HDR_DELIMITER = ":";
    static int PROTOCOL_HDR_SIZE = 19;
    static String PROTOCOL_REPLY_OK = "HELO";
    static String PROTOCOL_REPLY_OK_DELIMITER = ":";
    static String PROTOCOL_REPLY_DELIMITER = "\n";
    static byte PROTOCOL_IDENTIFY_REQUEST_NO_PEERINFO = (byte)12;
    static byte PROTOCOL_IDENTIFY_RESPONSE_NO_PEERINFO = (byte)13;
    static byte PROTOCOL_ONE_WAY = (byte)4;
    static byte PROTOCOL_REQUEST = (byte)5;
    static byte PROTOCOL_QOS_ANY = (byte)101;
    static byte PROTOCOL_QOS_SECURE = (byte)102;
    static byte PROTOCOL_FLAG_JVMID = 1;
    static byte PROTOCOL_FLAG_NONE = 0;
    static int PROTOCOL_RESPONSEID_NONE = -1;
    static int PROTOCOL_RESPONSEID = 1;
    static int PROTOCOL_INVOKEID_NONE = -1;
    static int PROTOCOL_INVOKEID_JMSCSHARP_SERVICE = 41;
    static int PROTOCOL_HEARTBEAT_DISABLE = 0;

    T3() {
    }

    static void writeLength(MarshalWriterImpl marshalWriterImpl, int n) {
        if (n >= 0) {
            if (n < 254) {
                marshalWriterImpl.write(n);
                return;
            }
            if (n <= 65535) {
                marshalWriterImpl.write(254);
                marshalWriterImpl.write(n >> 8);
                marshalWriterImpl.write(n & 0xFF);
                return;
            }
        }
        marshalWriterImpl.write(255);
        marshalWriterImpl.write(n >>> 24);
        marshalWriterImpl.write(n >>> 16);
        marshalWriterImpl.write(n >>> 8);
        marshalWriterImpl.write(n >>> 0);
    }

    static int getLengthNumBytes(int n) {
        if (n >= 0) {
            if (n < 254) {
                return 1;
            }
            if (n <= 65535) {
                return 3;
            }
        }
        return 5;
    }
}

