/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3client;

import weblogic.jms.dotnet.transport.t3client.MarshalWriterImpl;
import weblogic.jms.dotnet.transport.t3client.T3;
import weblogic.jms.dotnet.transport.t3client.T3JVMID;

class T3Abbrev {
    private final int id;
    private final byte[] content;
    static final T3Abbrev[] NULL_ABBREVS;

    T3Abbrev(int n, T3JVMID t3JVMID) {
        this.id = n;
        this.content = (byte[])(t3JVMID != null ? t3JVMID.getBuf() : null);
    }

    int getId() {
        return this.id;
    }

    byte[] getContent() {
        return this.content;
    }

    void write(MarshalWriterImpl marshalWriterImpl) {
        T3.writeLength(marshalWriterImpl, this.id);
        if (this.id > T3.PROTOCOL_ABBV_SIZE) {
            marshalWriterImpl.write(this.content, 0, this.content.length);
        }
    }

    int size() {
        int n = T3.getLengthNumBytes(this.id);
        if (this.id > T3.PROTOCOL_ABBV_SIZE) {
            n += this.content.length;
        }
        return n;
    }

    static {
        T3Abbrev[] t3AbbrevArray = new T3Abbrev[]{new T3Abbrev(255, null)};
        NULL_ABBREVS = t3AbbrevArray;
    }
}

