/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.t3client.MarshalReaderImpl;
import weblogic.jms.dotnet.transport.t3client.MarshalWriterImpl;
import weblogic.jms.dotnet.transport.t3client.T3;
import weblogic.jms.dotnet.transport.t3client.T3Abbrev;
import weblogic.jms.dotnet.transport.t3client.T3ConnectionLock;
import weblogic.jms.dotnet.transport.t3client.T3Header;
import weblogic.jms.dotnet.transport.t3client.T3JVMID;
import weblogic.jms.dotnet.transport.t3client.T3Message;
import weblogic.jms.dotnet.transport.t3client.T3PeerInfo;

public class T3Connection {
    private final T3ConnectionLock lock = new T3ConnectionLock();
    private static final boolean DEBUG = false;
    private static final SecureRandom RANDOM = new SecureRandom();
    static final byte T3_CONNECTION_DISPATCHER_ID_DEFAULT = 0;
    static final byte T3_CONNECTION_DISPATCHER_ID_TRANSPORT = 1;
    private static final byte REMOTE_INVOKE_HELLO_REQUEST = 1;
    private static final byte REMOTE_INVOKE_HELLO_RESPONSE = 2;
    private static final byte REMOTE_INVOKE_DISPATCH_REQUEST = 3;
    private static final byte REMOTE_INVOKE_FAILURE = 4;
    private static final int INIT = 0;
    private static final int LOGIN = 1;
    private static final int HELLO = 2;
    private static final int READY = 3;
    private static final int CLOSED = 4;
    private static final int CLIENT_RAWADDRESS = 0;
    private final Socket socket;
    private final OutputStream output;
    private final InputStream input;
    private final long transportId;
    private final T3PeerInfo lPeerInfo;
    private final T3PeerInfo rPeerInfo;
    private final T3JVMID lJvmId;
    private final T3JVMID rJvmId;
    private long scratchID;
    private final byte serviceId;
    private static final boolean SEQUENCE_ENABLED = false;
    private int nextSendSequenceId = 0;
    private int nextExpectedSequenceId = 0;
    private int state;
    private boolean inProgress = false;
    private final T3Header T3HEADER_IDENTIFY = new T3Header(T3.PROTOCOL_IDENTIFY_REQUEST_NO_PEERINFO, T3.PROTOCOL_QOS_ANY, T3.PROTOCOL_FLAG_JVMID, T3.PROTOCOL_RESPONSEID, T3.PROTOCOL_INVOKEID_NONE);
    private final T3Header T3HEADER_ONEWAY = new T3Header(T3.PROTOCOL_ONE_WAY, T3.PROTOCOL_QOS_ANY, T3.PROTOCOL_FLAG_NONE, T3.PROTOCOL_RESPONSEID_NONE, T3.PROTOCOL_INVOKEID_JMSCSHARP_SERVICE);
    private final T3Header T3HEADER_TWOWAY = new T3Header(T3.PROTOCOL_REQUEST, T3.PROTOCOL_QOS_ANY, T3.PROTOCOL_FLAG_NONE, T3.PROTOCOL_RESPONSEID, T3.PROTOCOL_INVOKEID_JMSCSHARP_SERVICE);
    private int backLog;
    private boolean hasWaiter;
    private MarshalWriterImpl first;
    private MarshalWriterImpl last;

    T3Connection(String string, int n, T3PeerInfo t3PeerInfo, byte by) throws Exception {
        this.scratchID = RANDOM.nextLong();
        this.lJvmId = new T3JVMID(1, this.scratchID, string, 0, null);
        this.rJvmId = new T3JVMID(1, 0L, string, 0, new int[]{n, -1, -1, -1, -1, -1, -1});
        this.serviceId = by;
        this.lPeerInfo = t3PeerInfo == null ? T3PeerInfo.defaultPeerInfo : t3PeerInfo;
        this.state = 0;
        this.inProgress = false;
        this.socket = new Socket(string, n);
        this.output = this.socket.getOutputStream();
        this.input = this.socket.getInputStream();
        this.state = 1;
        this.inProgress = true;
        MarshalWriterImpl marshalWriterImpl = T3Connection.createLoginRequest(this.lPeerInfo);
        this.sendSocket(marshalWriterImpl);
        this.rPeerInfo = T3Connection.processLoginResponse(this.input);
        MarshalWriterImpl marshalWriterImpl2 = T3Connection.createIdentifyRequest(this.lPeerInfo, this.lJvmId, this.rJvmId, this.T3HEADER_IDENTIFY);
        this.sendSocket(marshalWriterImpl2);
        T3Connection.processIdentifyResponse(this.input);
        this.state = 2;
        MarshalWriterImpl marshalWriterImpl3 = T3Connection.createHelloRequest(this.lPeerInfo, this.lJvmId, by, this.T3HEADER_TWOWAY);
        this.sendSocket(marshalWriterImpl3);
        this.transportId = T3Connection.processHelloResponse(this.input);
        this.state = 3;
        this.inProgress = false;
    }

    void sendSocket(MarshalWriterImpl marshalWriterImpl) throws IOException {
        marshalWriterImpl.copyTo(this.output);
    }

    T3PeerInfo getLocalPeerInfo() {
        return this.lPeerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T3PeerInfo getRemotePeerInfo() {
        T3ConnectionLock t3ConnectionLock = this.lock;
        synchronized (t3ConnectionLock) {
            return this.rPeerInfo;
        }
    }

    T3JVMID getLocalJVMID() {
        return this.lJvmId;
    }

    T3JVMID getRemoteJVMID() {
        return this.rJvmId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        T3ConnectionLock t3ConnectionLock = this.lock;
        synchronized (t3ConnectionLock) {
            if (this.state == 4) {
                return;
            }
            this.state = 4;
        }
        System.out.println("Debug: Closing T3 Conn " + this);
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MarshalReaderImpl receiveOneWay(Transport transport) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 3 || this.inProgress) {
                throw new Exception("Connection failure, state = " + this.getStateAsString());
            }
        }
        object = T3Connection.processResponse(this.input, false, transport);
        MarshalReaderImpl marshalReaderImpl = ((T3Message)object).getPayload();
        try {
            if (marshalReaderImpl == null || ((T3Message)object).getBodyLength() < 5) {
                throw new Exception("Unknown connection message syntax");
            }
            byte by = marshalReaderImpl.readByte();
            if (by != 3) {
                throw new Exception("Unknown connection opcode " + by);
            }
        }
        catch (Exception exception) {
            ((T3Message)object).cleanup();
            throw exception;
        }
        return marshalReaderImpl;
    }

    private static T3Message processResponse(InputStream inputStream, boolean bl) throws Exception {
        return T3Connection.processResponse(inputStream, bl, null);
    }

    private static T3Message processResponse(InputStream inputStream, boolean bl, Transport transport) throws Exception {
        T3Message t3Message = T3Message.readT3Message(inputStream, transport);
        return t3Message;
    }

    static MarshalWriterImpl createOneWay(MarshalWriterImpl marshalWriterImpl) {
        if (marshalWriterImpl == null) {
            marshalWriterImpl = new MarshalWriterImpl();
        }
        marshalWriterImpl.skip(19);
        marshalWriterImpl.skip(9);
        return marshalWriterImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendOneWay(MarshalWriterImpl marshalWriterImpl) throws Exception {
        MarshalWriterImpl marshalWriterImpl2 = null;
        T3ConnectionLock t3ConnectionLock = this.lock;
        synchronized (t3ConnectionLock) {
            if (this.state != 3 || this.inProgress) {
                marshalWriterImpl.closeInternal();
                throw new Exception("Connection is not ready");
            }
            ++this.backLog;
            marshalWriterImpl.setNext(null);
            if (this.last != null) {
                this.last.setNext(marshalWriterImpl);
                this.last = marshalWriterImpl;
                if (this.backLog > 32) {
                    this.hasWaiter = true;
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
            this.first = marshalWriterImpl;
            this.last = marshalWriterImpl;
            marshalWriterImpl2 = marshalWriterImpl;
        }
        while (true) {
            int n = marshalWriterImpl2.getPosition();
            marshalWriterImpl2.setPosition(19);
            marshalWriterImpl2.write(3);
            marshalWriterImpl2.writeLong(this.transportId);
            marshalWriterImpl2.setPosition(n);
            T3Message t3Message = new T3Message(this.T3HEADER_ONEWAY, T3Abbrev.NULL_ABBREVS);
            t3Message.write(marshalWriterImpl2);
            try {
                this.sendSocket(marshalWriterImpl2);
                continue;
            }
            finally {
                marshalWriterImpl2.closeInternal();
                T3ConnectionLock t3ConnectionLock2 = this.lock;
                synchronized (t3ConnectionLock2) {
                    --this.backLog;
                    this.first = this.first.getNext();
                    if (this.first == null) {
                        this.last = null;
                        if (this.hasWaiter) {
                            this.lock.notifyAll();
                        }
                        return;
                    }
                    marshalWriterImpl2 = this.first;
                }
                continue;
            }
            break;
        }
    }

    private static MarshalWriterImpl createLoginRequest(T3PeerInfo t3PeerInfo) {
        MarshalWriterImpl marshalWriterImpl = new MarshalWriterImpl();
        String string = T3.PROTOCOL_NAME + " " + t3PeerInfo.getVersion() + T3.PROTOCOL_DELIMITER + T3.PROTOCOL_ABBV + T3.PROTOCOL_ABBV_DELIMITER + T3.PROTOCOL_ABBV_SIZE + T3.PROTOCOL_DELIMITER + T3.PROTOCOL_HDR + T3.PROTOCOL_HDR_DELIMITER + T3.PROTOCOL_HDR_SIZE + T3.PROTOCOL_DELIMITER + T3.PROTOCOL_DELIMITER;
        int n = string.length();
        byte[] byArray = new byte[n];
        string.getBytes(0, n, byArray, 0);
        marshalWriterImpl.write(byArray, 0, byArray.length);
        return marshalWriterImpl;
    }

    private static T3PeerInfo processLoginResponse(InputStream inputStream) throws Exception {
        String string;
        String string2 = T3Connection.readLine(inputStream);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        if (stringTokenizer.countTokens() < 2) {
            throw new Exception("Unknown Login response  " + string2);
        }
        String string3 = stringTokenizer.nextToken();
        if (!string3.equalsIgnoreCase(T3.PROTOCOL_REPLY_OK)) {
            throw new Exception("Unknown Login response  " + string2);
        }
        string3 = stringTokenizer.nextToken();
        T3PeerInfo t3PeerInfo = new T3PeerInfo(string3);
        while ((string = T3Connection.readLine(inputStream)) != null && string.length() != 0) {
            T3Connection.checkConnectionParams(string);
        }
        return t3PeerInfo;
    }

    private static MarshalWriterImpl createIdentifyRequest(T3PeerInfo t3PeerInfo, T3JVMID t3JVMID, T3JVMID t3JVMID2, T3Header t3Header) throws Exception {
        MarshalWriterImpl marshalWriterImpl = new MarshalWriterImpl();
        marshalWriterImpl.skip(19);
        marshalWriterImpl.writeInt(T3.PROTOCOL_HEARTBEAT_DISABLE);
        marshalWriterImpl.writeInt(0);
        t3PeerInfo.write(marshalWriterImpl);
        T3Abbrev[] t3AbbrevArray = new T3Abbrev[]{new T3Abbrev(255, null), new T3Abbrev(256, t3JVMID2), new T3Abbrev(256, t3JVMID)};
        T3Message t3Message = new T3Message(t3Header, t3AbbrevArray);
        t3Message.write(marshalWriterImpl);
        return marshalWriterImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processIdentifyResponse(InputStream inputStream) throws Exception {
        T3Message t3Message = T3Connection.processResponse(inputStream, false);
        try {
            T3Header t3Header = t3Message.getMessageHeader();
            if (t3Header.getCommand() != T3.PROTOCOL_IDENTIFY_RESPONSE_NO_PEERINFO) {
                throw new Exception("Unknown identify response " + t3Header.getCommand());
            }
        }
        finally {
            t3Message.cleanup();
        }
    }

    private static MarshalWriterImpl createHelloRequest(T3PeerInfo t3PeerInfo, T3JVMID t3JVMID, byte by, T3Header t3Header) throws Exception {
        MarshalWriterImpl marshalWriterImpl = new MarshalWriterImpl();
        marshalWriterImpl.skip(19);
        marshalWriterImpl.write(1);
        t3PeerInfo.write(marshalWriterImpl);
        marshalWriterImpl.write(by);
        marshalWriterImpl.write(t3JVMID.getFlags());
        marshalWriterImpl.writeLong(t3JVMID.getDifferentiator());
        marshalWriterImpl.writeUTF(t3JVMID.getHostAddress());
        marshalWriterImpl.writeInt(t3JVMID.getRawAddress());
        marshalWriterImpl.writeInt(0);
        T3Message t3Message = new T3Message(t3Header, T3Abbrev.NULL_ABBREVS);
        t3Message.write(marshalWriterImpl);
        return marshalWriterImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long processHelloResponse(InputStream inputStream) throws Exception {
        T3Message t3Message = T3Connection.processResponse(inputStream, false);
        MarshalReaderImpl marshalReaderImpl = t3Message.getPayload();
        try {
            long l;
            byte by = marshalReaderImpl.readByte();
            if (by != 2) {
                throw new Exception("Expect hello response but got " + t3Message.getMessageHeader().getCommand() + "," + by);
            }
            long l2 = l = marshalReaderImpl.readLong();
            return l2;
        }
        finally {
            t3Message.cleanup();
        }
    }

    private static void checkConnectionParams(String string) throws Exception {
        if (string.charAt(0) == T3.PROTOCOL_ABBV.charAt(0) && string.charAt(1) == T3.PROTOCOL_ABBV.charAt(1) && string.charAt(2) == ':') {
            int n = Integer.parseInt(string.substring(3, string.length()));
        } else if (string.charAt(0) == T3.PROTOCOL_HDR.charAt(0) && string.charAt(1) == T3.PROTOCOL_HDR.charAt(1) && string.charAt(2) == ':') {
            int n = Integer.parseInt(string.substring(3, string.length()));
        } else {
            throw new Exception("Unknown connection parameters " + string);
        }
    }

    private static String readLine(InputStream inputStream) throws IOException {
        char[] cArray = new char[128];
        int n = 0;
        int n2 = inputStream.read();
        while (true) {
            if (n2 == -1) {
                if (n != 0) break;
                return null;
            }
            if (n2 == 10) {
                if (n <= 0 || cArray[n - 1] != '\r') break;
                --n;
                break;
            }
            if (n == cArray.length) {
                char[] cArray2 = cArray;
                cArray = new char[n + 128];
                System.arraycopy(cArray2, 0, cArray, 0, n);
            }
            cArray[n++] = (char)n2;
            n2 = inputStream.read();
        }
        return String.copyValueOf(cArray, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStateAsString() {
        T3ConnectionLock t3ConnectionLock = this.lock;
        synchronized (t3ConnectionLock) {
            switch (this.state) {
                case 0: {
                    return "INIT";
                }
                case 1: {
                    return "LOGIN";
                }
                case 2: {
                    return "HELLO";
                }
                case 3: {
                    return "READY";
                }
                case 4: {
                    return "CLOSED";
                }
            }
            return "UNKNOWN";
        }
    }

    public long getScratchID() {
        return this.scratchID;
    }

    public String toString() {
        return this.getStateAsString() + " " + (this.inProgress ? "In Progress" : "done");
    }
}

