/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3client;

import weblogic.jms.dotnet.transport.t3client.MarshalReaderImpl;
import weblogic.jms.dotnet.transport.t3client.MarshalWriterImpl;

public class T3Header {
    private final byte command;
    private final byte qos;
    private final byte flags;
    private final int responseId;
    private final int invokeId;
    private int len;
    private int offset;
    static final int SIZE = 19;

    T3Header(MarshalReaderImpl marshalReaderImpl) throws Exception {
        this.len = marshalReaderImpl.readInt();
        this.command = marshalReaderImpl.readByte();
        this.qos = marshalReaderImpl.readByte();
        this.flags = marshalReaderImpl.readByte();
        this.responseId = marshalReaderImpl.readInt();
        this.invokeId = marshalReaderImpl.readInt();
        this.offset = marshalReaderImpl.readInt();
    }

    T3Header(byte by, byte by2, byte by3, int n, int n2) {
        this.command = by;
        this.qos = by2;
        this.flags = by3;
        this.responseId = n;
        this.invokeId = n2;
    }

    synchronized void setMessageLength(int n) {
        this.len = n;
    }

    synchronized void setOffset(int n) {
        this.offset = n;
    }

    byte getCommand() {
        return this.command;
    }

    byte getQOS() {
        return this.qos;
    }

    byte getFlags() {
        return this.flags;
    }

    int getResponseId() {
        return this.responseId;
    }

    int getInvokeId() {
        return this.invokeId;
    }

    synchronized int getMessageLength() {
        return this.len;
    }

    synchronized int getOffset() {
        return this.offset;
    }

    public void write(MarshalWriterImpl marshalWriterImpl) throws Exception {
        marshalWriterImpl.writeInt(this.getMessageLength());
        marshalWriterImpl.writeByte(this.command);
        marshalWriterImpl.writeByte(this.qos);
        marshalWriterImpl.writeByte(this.flags);
        marshalWriterImpl.writeInt(this.responseId);
        marshalWriterImpl.writeInt(this.invokeId);
        marshalWriterImpl.writeInt(this.getOffset());
    }

    public String toString() {
        return "{  *****  header  *****" + "\tlength:     " + this.len + "\tcommand:    " + this.command + "\tqos:        " + this.qos + "\tflags:      " + this.flags + "\tresponseId: " + this.responseId + "\tinvokeId:   " + this.invokeId + "\toffset:     " + this.offset + "}";
    }
}

