/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.transport.t3client;

import weblogic.jms.dotnet.transport.t3client.MarshalWriterImpl;

final class T3JVMID {
    private static final long serialVersionUID = -2573312136796037590L;
    static final int INVALID_PORT = -1;
    private static final long INVALID_DIFFERENTIATOR = 0L;
    static final byte HAS_HOST_ADDRESS = 1;
    private static final byte HAS_ROUTER = 2;
    private static final byte HAS_CLUSTER_ADDRESS = 4;
    static final byte HAS_DOMAIN_NAME = 8;
    static final byte HAS_SERVER_NAME = 16;
    static final byte HAS_DNS_NAME = 32;
    private static final byte HAS_CHANNEL = 64;
    private static final byte SC_BLOCK_DATA = 8;
    private static final byte SC_EXTERNALIZABLE = 4;
    private static final byte TC_NULL = 112;
    private static final byte TC_CLASSDESC = 114;
    private static final byte TC_OBJECT = 115;
    private static final byte TC_BLOCKDATA = 119;
    private static final byte TC_ENDBLOCKDATA = 120;
    private static final short STREAM_MAGIC = -21267;
    private static final short STREAM_VERSION = 5;
    private static final String className = "weblogic.rjvm.JVMID";
    private byte flags;
    private String hostAddress;
    private String clusterAddress;
    private byte arrayLength;
    private long differentiator;
    private int rawAddress;
    private int[] ports;
    private String domainName;
    private String serverName;
    private String dnsName;
    private byte[] buf;

    T3JVMID(byte by, long l, String string, int n, int[] nArray) {
        this.flags = by;
        this.differentiator = l;
        this.hostAddress = string;
        this.rawAddress = n;
        if (nArray != null) {
            this.ports = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.ports[i] = nArray[i];
            }
        }
        MarshalWriterImpl marshalWriterImpl = new MarshalWriterImpl();
        marshalWriterImpl.write(0);
        this.write(marshalWriterImpl);
        this.buf = marshalWriterImpl.toByteArray();
    }

    byte getFlags() {
        return this.flags;
    }

    byte[] getBuf() {
        return this.buf;
    }

    long getDifferentiator() {
        return this.differentiator;
    }

    String getHostAddress() {
        return this.hostAddress;
    }

    int getRawAddress() {
        return this.rawAddress;
    }

    private void write2(MarshalWriterImpl marshalWriterImpl) {
        marshalWriterImpl.write(this.buf, 0, this.buf.length);
    }

    private void write(MarshalWriterImpl marshalWriterImpl) {
        int n;
        marshalWriterImpl.writeShort((short)-21267);
        marshalWriterImpl.writeShort((short)5);
        marshalWriterImpl.write(115);
        marshalWriterImpl.write(114);
        marshalWriterImpl.writeUTF(className);
        marshalWriterImpl.writeLong(-2573312136796037590L);
        marshalWriterImpl.write(12);
        marshalWriterImpl.writeShort(0);
        marshalWriterImpl.write(120);
        marshalWriterImpl.write(112);
        marshalWriterImpl.write(119);
        int n2 = marshalWriterImpl.getPosition();
        marshalWriterImpl.skip(1);
        marshalWriterImpl.write(this.flags);
        marshalWriterImpl.writeLong(this.differentiator);
        marshalWriterImpl.writeUTF(this.hostAddress);
        if (this.dnsName != null) {
            marshalWriterImpl.writeUTF(this.dnsName);
        }
        marshalWriterImpl.writeInt(this.rawAddress);
        if (this.ports == null || this.ports.length == 0) {
            marshalWriterImpl.writeInt(0);
        } else {
            marshalWriterImpl.writeInt(this.ports.length);
            for (n = 0; n < this.ports.length; ++n) {
                marshalWriterImpl.writeInt(this.ports[n]);
            }
        }
        n = marshalWriterImpl.getPosition();
        int n3 = n - n2 - 1;
        marshalWriterImpl.setPosition(n2);
        marshalWriterImpl.write(n3);
        marshalWriterImpl.setPosition(n);
        marshalWriterImpl.write(120);
    }
}

